/*
 * Decompiled with CFR 0.152.
 */
package com.cff1028.schematicsfix;

import com.cff1028.schematicsfix.SchematicFixMod;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.RegisterCommandsEvent;

@EventBusSubscriber(modid="schematicsfix")
public class SchematicConfigCommand {
    @SubscribeEvent
    public static void onRegisterCommands(RegisterCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"schematic-config").requires(source -> source.hasPermission(2))).then(Commands.literal((String)"reload").executes(SchematicConfigCommand::reloadConfig))).then(Commands.literal((String)"status").executes(SchematicConfigCommand::showStatus))).then(Commands.literal((String)"keywords").executes(SchematicConfigCommand::showKeywords)));
    }

    private static int reloadConfig(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        SchematicFixMod mod = SchematicFixMod.getInstance();
        if (mod != null && mod.getNbtDetector() != null) {
            boolean success = mod.getNbtDetector().reloadConfig();
            int ruleCount = mod.getNbtDetector().getRuleCount();
            int keywordCount = mod.getNbtDetector().getBannedKeywordCount();
            if (success) {
                source.sendSuccess(() -> Component.literal((String)("\u00a7aConfiguration reloaded successfully! " + ruleCount + " filter rules and " + keywordCount + " banned keywords have been loaded.")), true);
                SchematicFixMod.LOGGER.info("Configuration reloaded successfully by {} with {} rules and {} banned keywords", (Object)source.getTextName(), (Object)ruleCount, (Object)keywordCount);
                return 1;
            }
            source.sendFailure((Component)Component.literal((String)"\u00a7cConfiguration reload failed! Please check the console log for more details."));
            return 0;
        }
        source.sendFailure((Component)Component.literal((String)"\u00a7cSchematicFix Mod was not initialized correctly and cannot reload the configuration."));
        return 0;
    }

    private static int showStatus(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        SchematicFixMod mod = SchematicFixMod.getInstance();
        if (mod != null && mod.getNbtDetector() != null) {
            int ruleCount = mod.getNbtDetector().getRuleCount();
            int keywordCount = mod.getNbtDetector().getBannedKeywordCount();
            boolean fileWatcherRunning = mod.isFileWatcherRunning();
            source.sendSuccess(() -> Component.literal((String)("\u00a76SchematicFix Mod condition:\n\u00a77- Filter rules loaded: \u00a7e" + ruleCount + "\n\u00a77- Prohibited keywords loaded: \u00a7e" + keywordCount + "\n\u00a77- File Monitor Status: \u00a7e" + (fileWatcherRunning ? "\u8fd0\u884c\u4e2d" : "\u672a\u8fd0\u884c") + "\n\u00a77- Use \u00a7e/schematic-config reload \u00a77to reload configuration\n\u00a77- Use \u00a7e/schematic-config keywords \u00a77to view the list of prohibited keywords")), false);
            return 1;
        }
        source.sendFailure((Component)Component.literal((String)"\u00a7cSchematicFix Mod was not initialized correctly."));
        return 0;
    }

    private static int showKeywords(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        SchematicFixMod mod = SchematicFixMod.getInstance();
        if (mod != null && mod.getNbtDetector() != null) {
            List<String> keywords = mod.getNbtDetector().getBannedKeywords();
            StringBuilder keywordList = new StringBuilder();
            for (int i = 0; i < keywords.size(); ++i) {
                if (i > 0) {
                    keywordList.append(", ");
                }
                keywordList.append("\u00a7c").append(keywords.get(i)).append("\u00a77");
            }
            source.sendSuccess(() -> Component.literal((String)("\u00a76List of banned keywords (" + keywords.size() + " ):\n\u00a77" + keywordList.toString())), false);
            return 1;
        }
        source.sendFailure((Component)Component.literal((String)"\u00a7cSchematicFix Mod was not initialized correctly."));
        return 0;
    }
}

