/*
 * Decompiled with CFR 0.152.
 */
package com.cff1028.schematicsfix;

import com.cff1028.schematicsfix.Config;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPOutputStream;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SchematicNBTDetector {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Set<String> DEFAULT_IGNORED_KEYS = Set.of("count", "id");
    private final Path configPath = Paths.get("config/schematicsfix.jsonl", new String[0]).toAbsolutePath();
    private final List<FilterRule> filterRules = new ArrayList<FilterRule>();
    private final List<String> bannedKeywords = new ArrayList<String>();

    public SchematicNBTDetector() {
        this.loadConfig();
    }

    private void loadConfig() {
        if (!Files.exists(this.configPath, new LinkOption[0])) {
            try {
                Files.createDirectories(this.configPath.getParent(), new FileAttribute[0]);
                this.copyDefaultConfig();
                LOGGER.info("Created default config file from assets: {}", (Object)this.configPath);
            }
            catch (IOException e) {
                LOGGER.error("Failed to create config file: {}", (Object)this.configPath, (Object)e);
            }
            return;
        }
        this.reloadConfigInternal();
    }

    public List<String> getBannedKeywords() {
        return new ArrayList<String>(this.bannedKeywords);
    }

    public boolean reloadConfig() {
        LOGGER.info("Reloading schematic filter configuration...");
        boolean success = this.reloadConfigInternal();
        this.loadBannedKeywords();
        return success;
    }

    private void loadBannedKeywords() {
        this.bannedKeywords.clear();
        try {
            List keywords = (List)Config.INSTANCE.bannedKeywords.get();
            this.bannedKeywords.addAll(keywords);
            LOGGER.info("Loaded {} banned keywords: {}", (Object)this.bannedKeywords.size(), this.bannedKeywords);
        }
        catch (Exception e) {
            LOGGER.error("Failed to load banned keywords from config", (Throwable)e);
            this.bannedKeywords.addAll(Arrays.asList("clickEvent", "run_command", "create:filter", "create:attribute_filter"));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean reloadConfigInternal() {
        this.filterRules.clear();
        this.loadBannedKeywords();
        int lineNumber = 0;
        int loadedRules = 0;
        try (BufferedReader reader = Files.newBufferedReader(this.configPath);){
            String line;
            while ((line = reader.readLine()) != null) {
                ++lineNumber;
                if ((line = line.trim()).isEmpty()) continue;
                try {
                    JsonObject ruleJson = JsonParser.parseString((String)line).getAsJsonObject();
                    FilterRule rule = this.parseFilterRule(ruleJson);
                    if (rule == null) continue;
                    this.filterRules.add(rule);
                    ++loadedRules;
                    LOGGER.debug("Loaded filter rule for id: {}", (Object)rule.id);
                }
                catch (Exception e) {
                    LOGGER.warn("Failed to parse rule at line {}: {}", (Object)lineNumber, (Object)line, (Object)e);
                }
            }
            LOGGER.info("Loaded {} filter rules from config", (Object)loadedRules);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            LOGGER.error("Failed to load config file: {}", (Object)this.configPath, (Object)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyDefaultConfig() {
        block28: {
            InputStream inputStream = null;
            try {
                inputStream = this.getClass().getResourceAsStream("/assets/schematicsfix/schematicsfix.jsonl");
                if (inputStream == null) {
                    inputStream = this.getClass().getClassLoader().getResourceAsStream("assets/schematicsfix/schematicsfix.jsonl");
                }
                if (inputStream != null) {
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
                         BufferedWriter writer = Files.newBufferedWriter(this.configPath, new OpenOption[0]);){
                        String line;
                        while ((line = reader.readLine()) != null) {
                            writer.write(line);
                            writer.newLine();
                        }
                        LOGGER.info("Successfully copied default config from assets");
                        break block28;
                    }
                }
                LOGGER.warn("Default config not found in assets, creating example config file");
                this.createExampleConfig();
            }
            catch (Exception e) {
                LOGGER.error("Failed to copy default config from assets", (Throwable)e);
                try {
                    this.createExampleConfig();
                }
                catch (IOException ex) {
                    LOGGER.error("Failed to create example config file", (Throwable)ex);
                }
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {
                        LOGGER.error("Error closing input stream", (Throwable)e);
                    }
                }
            }
        }
    }

    private void createExampleConfig() throws IOException {
        try (BufferedWriter writer = Files.newBufferedWriter(this.configPath, new OpenOption[0]);){
            JsonObject chestRule = new JsonObject();
            chestRule.addProperty("id", "minecraft:chest");
            JsonArray blacklist = new JsonArray();
            blacklist.add("Items");
            blacklist.add("Lock");
            blacklist.add("LootTable");
            chestRule.add("blacklist", (JsonElement)blacklist);
            writer.write(GSON.toJson((JsonElement)chestRule));
            writer.newLine();
            JsonObject shulkerRule = new JsonObject();
            shulkerRule.addProperty("id", "minecraft:shulker_box");
            shulkerRule.add("blacklist", (JsonElement)blacklist);
            writer.write(GSON.toJson((JsonElement)shulkerRule));
            writer.newLine();
            LOGGER.info("Created example configuration");
        }
    }

    private FilterRule parseFilterRule(JsonObject json) {
        if (!json.has("id")) {
            return null;
        }
        String id = json.get("id").getAsString();
        FilterRule rule = new FilterRule(id);
        if (json.has("whitelist") && json.has("blacklist")) {
            LOGGER.warn("Rule for id '{}' has both whitelist and blacklist, ignoring this rule", (Object)id);
            return null;
        }
        if (json.has("whitelist")) {
            rule.whitelist = new HashSet<String>();
            json.get("whitelist").getAsJsonArray().forEach(element -> rule.whitelist.add(element.getAsString()));
        }
        if (json.has("blacklist")) {
            rule.blacklist = new HashSet<String>();
            json.get("blacklist").getAsJsonArray().forEach(element -> rule.blacklist.add(element.getAsString()));
        }
        if (json.has("include")) {
            rule.include = this.parseIncludeRules(json.get("include").getAsJsonObject());
        }
        return rule;
    }

    private Map<String, FilterRule> parseIncludeRules(JsonObject includeJson) {
        HashMap<String, FilterRule> includeRules = new HashMap<String, FilterRule>();
        for (String key : includeJson.keySet()) {
            JsonObject ruleJson = includeJson.get(key).getAsJsonObject();
            FilterRule includeRule = new FilterRule(null);
            if (ruleJson.has("whitelist") && ruleJson.has("blacklist")) {
                LOGGER.warn("Include rule has both whitelist and blacklist, ignoring this include rule");
                continue;
            }
            if (ruleJson.has("whitelist")) {
                includeRule.whitelist = new HashSet<String>();
                ruleJson.get("whitelist").getAsJsonArray().forEach(element -> includeRule.whitelist.add(element.getAsString()));
            }
            if (ruleJson.has("blacklist")) {
                includeRule.blacklist = new HashSet<String>();
                ruleJson.get("blacklist").getAsJsonArray().forEach(element -> includeRule.blacklist.add(element.getAsString()));
            }
            if (ruleJson.has("include")) {
                includeRule.include = this.parseIncludeRules(ruleJson.get("include").getAsJsonObject());
            }
            includeRules.put(key, includeRule);
        }
        return includeRules;
    }

    public int getRuleCount() {
        return this.filterRules.size();
    }

    public int getBannedKeywordCount() {
        return this.bannedKeywords.size();
    }

    public DetectionResult detectAnomalies(String playerName, String fileName) {
        Path schematicPath = Paths.get("schematics/uploaded", playerName, fileName + ".nbt").toAbsolutePath();
        Path anomalyPath = Paths.get("schematics/anomaly", playerName, fileName + ".nbt").toAbsolutePath();
        Path bannedPath = Paths.get("schematics/banned", playerName, fileName + ".nbt").toAbsolutePath();
        if (!Files.exists(schematicPath, new LinkOption[0])) {
            return new DetectionResult(false, "Schematic file not found: " + String.valueOf(schematicPath));
        }
        try {
            CompoundTag nbt = this.readNbtFile(schematicPath);
            if (nbt == null) {
                return new DetectionResult(false, "Failed to read NBT file - unsupported compression or corrupted file");
            }
            boolean bannedKeywordFound = false;
            String bannedKeywordMessage = "";
            BannedKeywordCleanResult bannedResult = this.checkAndCleanBannedKeywords(nbt, playerName, fileName);
            if (bannedResult.found) {
                bannedKeywordFound = true;
                bannedKeywordMessage = String.format("Banned keyword '%s' detected and cleaned.", bannedResult.keyword);
                Files.createDirectories(bannedPath.getParent(), new FileAttribute[0]);
                Files.copy(schematicPath, bannedPath, StandardCopyOption.REPLACE_EXISTING);
                LOGGER.warn("BANNED KEYWORD DETECTED AND CLEANED: File {}.nbt from player {} contained banned keyword '{}'. Original backed up to banned directory.", (Object)fileName, (Object)playerName, (Object)bannedResult.keyword);
            }
            boolean ruleModified = this.processBlocks(nbt, playerName, fileName);
            if (bannedKeywordFound || ruleModified) {
                this.writeNbtFile(nbt, schematicPath);
                StringBuilder messageBuilder = new StringBuilder();
                if (bannedKeywordFound) {
                    messageBuilder.append(bannedKeywordMessage);
                    if (ruleModified) {
                        messageBuilder.append(" ");
                    }
                }
                if (ruleModified) {
                    if (((Boolean)Config.INSTANCE.backupAnomalousFiles.get()).booleanValue()) {
                        Files.createDirectories(anomalyPath.getParent(), new FileAttribute[0]);
                        Files.copy(schematicPath, anomalyPath, StandardCopyOption.REPLACE_EXISTING);
                        messageBuilder.append("Rule-based anomalies detected and cleaned. Original backed up to anomaly directory.");
                        LOGGER.warn("Anomalous schematic {}.nbt has been detected from player {}. Original backed up.", (Object)fileName, (Object)playerName);
                    } else {
                        messageBuilder.append("Rule-based anomalies detected and cleaned.");
                        LOGGER.warn("Anomalous schematic {}.nbt has been detected from player {}.", (Object)fileName, (Object)playerName);
                    }
                }
                return new DetectionResult(true, messageBuilder.toString());
            }
            return new DetectionResult(false, "No anomalies detected in schematic.");
        }
        catch (IOException e) {
            LOGGER.error("Error processing schematic file: {}", (Object)schematicPath, (Object)e);
            return new DetectionResult(false, "Error processing schematic: " + e.getMessage());
        }
        catch (Exception e) {
            LOGGER.error("Unexpected error processing schematic file: {}", (Object)schematicPath, (Object)e);
            return new DetectionResult(false, "Unexpected error: " + e.getMessage());
        }
    }

    private BannedKeywordCleanResult checkAndCleanBannedKeywords(CompoundTag nbt, String playerName, String fileName) {
        ArrayList<BannedKeywordFinding> findings = new ArrayList<BannedKeywordFinding>();
        this.collectBannedKeywordFindings((Tag)nbt, "", findings);
        if (findings.isEmpty()) {
            return new BannedKeywordCleanResult(false, null, null, null);
        }
        findings.sort((a, b) -> Integer.compare(b.path.split("\\.").length, a.path.split("\\.").length));
        for (BannedKeywordFinding finding : findings) {
            if (!this.removeTagAtPath(nbt, finding.path)) continue;
            LOGGER.info("Removed banned keyword '{}' at path {}", (Object)finding.keyword, (Object)finding.path);
        }
        return new BannedKeywordCleanResult(true, ((BannedKeywordFinding)findings.get((int)0)).keyword, ((BannedKeywordFinding)findings.get((int)0)).path, ((BannedKeywordFinding)findings.get((int)0)).value);
    }

    private void collectBannedKeywordFindings(Tag tag, String currentPath, List<BannedKeywordFinding> findings) {
        block6: {
            block11: {
                block10: {
                    block9: {
                        block8: {
                            block7: {
                                if (!(tag instanceof CompoundTag)) break block7;
                                CompoundTag compound = (CompoundTag)tag;
                                for (String key : compound.getAllKeys()) {
                                    Tag child = compound.get(key);
                                    String childPath = currentPath.isEmpty() ? key : currentPath + "." + key;
                                    this.collectBannedKeywordFindings(child, childPath, findings);
                                }
                                break block6;
                            }
                            if (!(tag instanceof ListTag)) break block8;
                            ListTag list = (ListTag)tag;
                            for (int i = 0; i < list.size(); ++i) {
                                Tag child = list.get(i);
                                String childPath = currentPath + "[" + i + "]";
                                this.collectBannedKeywordFindings(child, childPath, findings);
                            }
                            break block6;
                        }
                        if (!(tag instanceof StringTag)) break block9;
                        StringTag stringTag = (StringTag)tag;
                        String value = stringTag.getAsString();
                        for (String keyword : this.bannedKeywords) {
                            if (!value.contains(keyword)) continue;
                            findings.add(new BannedKeywordFinding(keyword, currentPath, value));
                            LOGGER.debug("Found banned keyword '{}' in NBT path {} with value: {}", (Object)keyword, (Object)currentPath, (Object)value);
                            break block6;
                        }
                        break block6;
                    }
                    if (!(tag instanceof ByteArrayTag)) break block10;
                    ByteArrayTag byteArray = (ByteArrayTag)tag;
                    byte[] bytes = byteArray.getAsByteArray();
                    String byteString = Arrays.toString(bytes);
                    for (String keyword : this.bannedKeywords) {
                        if (!byteString.contains(keyword)) continue;
                        findings.add(new BannedKeywordFinding(keyword, currentPath, "[byte array]"));
                        LOGGER.debug("Found banned keyword '{}' in byte array at path {}", (Object)keyword, (Object)currentPath);
                        break block6;
                    }
                    break block6;
                }
                if (!(tag instanceof IntArrayTag)) break block11;
                IntArrayTag intArray = (IntArrayTag)tag;
                int[] ints = intArray.getAsIntArray();
                String intString = Arrays.toString(ints);
                for (String keyword : this.bannedKeywords) {
                    if (!intString.contains(keyword)) continue;
                    findings.add(new BannedKeywordFinding(keyword, currentPath, "[int array]"));
                    LOGGER.debug("Found banned keyword '{}' in int array at path {}", (Object)keyword, (Object)currentPath);
                    break block6;
                }
                break block6;
            }
            if (!(tag instanceof LongArrayTag)) break block6;
            LongArrayTag longArray = (LongArrayTag)tag;
            long[] longs = longArray.getAsLongArray();
            String longString = Arrays.toString(longs);
            for (String keyword : this.bannedKeywords) {
                if (!longString.contains(keyword)) continue;
                findings.add(new BannedKeywordFinding(keyword, currentPath, "[long array]"));
                LOGGER.debug("Found banned keyword '{}' in long array at path {}", (Object)keyword, (Object)currentPath);
                break;
            }
        }
    }

    private boolean removeTagAtPath(CompoundTag root, String path) {
        if (path.isEmpty()) {
            return false;
        }
        String[] pathParts = path.split("\\.");
        CompoundTag current = root;
        for (int i = 0; i < pathParts.length - 1; ++i) {
            Tag index2;
            String part = pathParts[i];
            if (part.contains("[")) {
                Tag tag;
                String listName = part.substring(0, part.indexOf("["));
                int index2 = Integer.parseInt(part.substring(part.indexOf("[") + 1, part.indexOf("]")));
                if (current.contains(listName) && (tag = current.get(listName)) instanceof ListTag) {
                    Tag tag2;
                    ListTag list = (ListTag)tag;
                    if (index2 < list.size() && (tag2 = list.get(index2)) instanceof CompoundTag) {
                        CompoundTag compound;
                        current = compound = (CompoundTag)tag2;
                        continue;
                    }
                    return false;
                }
                return false;
            }
            if (current.contains(part) && (index2 = current.get(part)) instanceof CompoundTag) {
                CompoundTag compound;
                current = compound = (CompoundTag)index2;
                continue;
            }
            return false;
        }
        String targetKey = pathParts[pathParts.length - 1];
        if (targetKey.contains("[")) {
            ListTag list;
            Tag tag;
            String listName = targetKey.substring(0, targetKey.indexOf("["));
            int index = Integer.parseInt(targetKey.substring(targetKey.indexOf("[") + 1, targetKey.indexOf("]")));
            if (current.contains(listName) && (tag = current.get(listName)) instanceof ListTag && index < (list = (ListTag)tag).size()) {
                list.remove(index);
                return true;
            }
        } else if (current.contains(targetKey)) {
            current.remove(targetKey);
            return true;
        }
        return false;
    }

    /*
     * Exception decompiling
     */
    private CompoundTag readNbtFile(Path filePath) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void writeNbtFile(CompoundTag nbt, Path filePath) throws IOException {
        try (OutputStream os = Files.newOutputStream(filePath, new OpenOption[0]);
             GZIPOutputStream gzipOs = new GZIPOutputStream(os);
             DataOutputStream dataOs = new DataOutputStream(gzipOs);){
            NbtIo.write((CompoundTag)nbt, (DataOutput)dataOs);
        }
    }

    private boolean processBlocks(CompoundTag rootNbt, String playerName, String fileName) {
        if (!rootNbt.contains("blocks", 9)) {
            LOGGER.debug("No blocks found in NBT file {}.nbt", (Object)fileName);
            return false;
        }
        ListTag blocks = rootNbt.getList("blocks", 10);
        boolean modified = false;
        LOGGER.debug("Processing {} blocks in file {}.nbt", (Object)blocks.size(), (Object)fileName);
        for (int i = 0; i < blocks.size(); ++i) {
            CompoundTag block = blocks.getCompound(i);
            if (!block.contains("nbt", 10)) continue;
            CompoundTag nbtData = block.getCompound("nbt");
            modified |= this.processNbtData(nbtData, playerName, fileName);
        }
        return modified;
    }

    private boolean processNbtData(CompoundTag nbtData, String playerName, String fileName) {
        boolean modified = false;
        for (String key : nbtData.getAllKeys()) {
            Tag tag = nbtData.get(key);
            if (!(tag instanceof CompoundTag)) continue;
            CompoundTag itemData = (CompoundTag)tag;
            modified |= this.processItemData(itemData, key, playerName, fileName);
        }
        return modified;
    }

    private boolean processItemData(CompoundTag itemData, String parentKey, String playerName, String fileName) {
        if (!itemData.contains("id", 8)) {
            return false;
        }
        String itemId = itemData.getString("id");
        FilterRule matchingRule = this.findMatchingRule(itemId);
        if (matchingRule == null) {
            return false;
        }
        LOGGER.debug("Applying filter rule for item '{}' in file {}.nbt", (Object)itemId, (Object)fileName);
        return this.applyFilterRule(itemData, matchingRule, playerName, fileName, itemId);
    }

    private FilterRule findMatchingRule(String itemId) {
        for (FilterRule rule : this.filterRules) {
            if (!rule.id.equals(itemId)) continue;
            return rule;
        }
        return null;
    }

    private boolean applyFilterRule(CompoundTag data, FilterRule rule, String playerName, String fileName, String itemId) {
        boolean modified = false;
        HashSet<String> keysToRemove = new HashSet<String>();
        for (String string : data.getAllKeys()) {
            if (DEFAULT_IGNORED_KEYS.contains(string)) continue;
            if (rule.whitelist != null) {
                if (rule.whitelist.contains(string)) continue;
                keysToRemove.add(string);
                continue;
            }
            if (rule.blacklist == null || !rule.blacklist.contains(string)) continue;
            keysToRemove.add(string);
        }
        for (String string : keysToRemove) {
            data.remove(string);
            modified = true;
            LOGGER.info("Removed key '{}' from item '{}' in file {}.nbt", (Object)string, (Object)itemId, (Object)fileName);
        }
        if (rule.include != null) {
            for (Map.Entry entry : rule.include.entrySet()) {
                Tag tag;
                String includeKey = (String)entry.getKey();
                FilterRule includeRule = (FilterRule)entry.getValue();
                if (!data.contains(includeKey) || !((tag = data.get(includeKey)) instanceof CompoundTag)) continue;
                CompoundTag includeData = (CompoundTag)tag;
                modified |= this.applyIncludeRule(includeData, includeRule, playerName, fileName, itemId, includeKey);
            }
        }
        return modified;
    }

    private boolean applyIncludeRule(CompoundTag data, FilterRule rule, String playerName, String fileName, String itemId, String path) {
        boolean modified = false;
        HashSet<String> keysToRemove = new HashSet<String>();
        for (String string : data.getAllKeys()) {
            if (rule.whitelist != null) {
                if (rule.whitelist.contains(string)) continue;
                keysToRemove.add(string);
                continue;
            }
            if (rule.blacklist == null || !rule.blacklist.contains(string)) continue;
            keysToRemove.add(string);
        }
        for (String string : keysToRemove) {
            data.remove(string);
            modified = true;
            LOGGER.info("Removed key '{}' from path '{}' in item '{}' in file {}.nbt", (Object)string, (Object)path, (Object)itemId, (Object)fileName);
        }
        if (rule.include != null) {
            for (Map.Entry entry : rule.include.entrySet()) {
                Tag tag;
                String includeKey = (String)entry.getKey();
                FilterRule includeRule = (FilterRule)entry.getValue();
                if (!data.contains(includeKey) || !((tag = data.get(includeKey)) instanceof CompoundTag)) continue;
                CompoundTag includeData = (CompoundTag)tag;
                modified |= this.applyIncludeRule(includeData, includeRule, playerName, fileName, itemId, path + "." + includeKey);
            }
        }
        return modified;
    }

    private static class FilterRule {
        final String id;
        Set<String> whitelist;
        Set<String> blacklist;
        Map<String, FilterRule> include;

        FilterRule(String id) {
            this.id = id;
        }
    }

    public static class DetectionResult {
        public final boolean hasAnomalies;
        public final String message;

        public DetectionResult(boolean hasAnomalies, String message) {
            this.hasAnomalies = hasAnomalies;
            this.message = message;
        }
    }

    private static class BannedKeywordCleanResult {
        public final boolean found;
        public final String keyword;
        public final String path;
        public final String value;

        public BannedKeywordCleanResult(boolean found, String keyword, String path, String value) {
            this.found = found;
            this.keyword = keyword;
            this.path = path;
            this.value = value;
        }
    }

    private static class BannedKeywordFinding {
        public final String keyword;
        public final String path;
        public final String value;

        public BannedKeywordFinding(String keyword, String path, String value) {
            this.keyword = keyword;
            this.path = path;
            this.value = value;
        }
    }
}

