/*
 * Decompiled with CFR 0.152.
 */
package com.cff1028.schematicsfix;

import java.util.Arrays;
import java.util.List;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class Config {
    public static final ModConfigSpec SPEC;
    public static final Config INSTANCE;
    public final ModConfigSpec.BooleanValue enableFileWatcher;
    public final ModConfigSpec.LongValue stableCheckInterval;
    public final ModConfigSpec.LongValue maxStableTime;
    public final ModConfigSpec.BooleanValue autoCleanAnomalies;
    public final ModConfigSpec.BooleanValue backupAnomalousFiles;
    public final ModConfigSpec.ConfigValue<List<? extends String>> bannedKeywords;

    public Config(ModConfigSpec.Builder builder) {
        builder.comment("Schematic Fix Mod Configuration").push("general");
        this.enableFileWatcher = builder.comment("Enable file watcher for schematic uploads").define("enableFileWatcher", true);
        this.stableCheckInterval = builder.comment("Interval in milliseconds to check file stability").defineInRange("stableCheckInterval", 200L, 50L, 5000L);
        this.maxStableTime = builder.comment("Maximum time in milliseconds to consider a file stable").defineInRange("maxStableTime", 500L, 100L, 10000L);
        this.autoCleanAnomalies = builder.comment("Automatically clean detected anomalies").define("autoCleanAnomalies", true);
        this.backupAnomalousFiles = builder.comment("Backup anomalous files to anomaly directory").define("backupAnomalousFiles", true);
        this.bannedKeywords = builder.comment("List of banned keywords that will cause immediate file deletion when found in NBT").defineList("bannedKeywords", Arrays.asList("clickEvent", "run_command", "create:filter", "create:attribute_filter"), obj -> obj instanceof String);
        builder.pop();
    }

    static {
        Pair specPair = new ModConfigSpec.Builder().configure(Config::new);
        SPEC = (ModConfigSpec)specPair.getRight();
        INSTANCE = (Config)specPair.getLeft();
    }
}

