/*
 * Decompiled with CFR 0.152.
 */
package com.rouesvm.servback;

import com.rouesvm.servback.compat.geyser.BackpackGeyser;
import com.rouesvm.servback.compat.trinkets.BackpackTrinket;
import com.rouesvm.servback.registry.BackpackDataComponentTypes;
import com.rouesvm.servback.registry.BackpackRecipeRegistry;
import com.rouesvm.servback.registry.BackpackUpgradeRegistry;
import com.rouesvm.servback.registry.block.BackpackBlockEntityRegistry;
import com.rouesvm.servback.registry.block.BackpackBlockRegistry;
import com.rouesvm.servback.registry.item.BackpackItemGroup;
import com.rouesvm.servback.registry.item.BackpackItemJsonRegistry;
import com.rouesvm.servback.registry.item.BackpackItemRegistry;
import com.rouesvm.servback.technical.config.BackpackItemConfiguration;
import com.rouesvm.servback.technical.config.Configuration;
import com.rouesvm.servback.technical.config.commands.BackpackCommands;
import com.rouesvm.servback.technical.data.BackpackData;
import com.rouesvm.servback.technical.manager.BackpackManager;
import eu.pb4.polymer.resourcepack.api.PolymerResourcePackUtils;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Set;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.entity.event.v1.ServerPlayerEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1887;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerBackpacks
implements ModInitializer {
    public static final String MOD_ID = "serverbackpacks";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"serverbackpacks");
    public static final class_5321<class_1887> CAPACITY = class_5321.method_29179((class_5321)class_7924.field_41265, (class_2960)class_2960.method_60655((String)"serverbackpacks", (String)"capacity"));
    private static final Set<class_3222> BEDROCK_PLAYERS = new ObjectOpenHashSet();
    public static boolean hasGeyserLoaded;
    public static boolean hasTrinketLoaded;
    public static boolean isDevEnvironment;

    public void onInitialize() {
        isDevEnvironment = FabricLoader.getInstance().isDevelopmentEnvironment();
        hasTrinketLoaded = FabricLoader.getInstance().isModLoaded("trinkets");
        hasGeyserLoaded = FabricLoader.getInstance().isModLoaded("geyser-fabric");
        PolymerResourcePackUtils.addModAssets((String)MOD_ID);
        PolymerResourcePackUtils.markAsRequired();
        Configuration.initialize();
        BackpackItemConfiguration.initialize();
        BackpackDataComponentTypes.initialize();
        BackpackBlockEntityRegistry.initialize();
        BackpackBlockRegistry.initialize();
        BackpackItemJsonRegistry.initialize();
        BackpackItemRegistry.initialize();
        BackpackItemGroup.initialize();
        BackpackCommands.initialize();
        BackpackRecipeRegistry.initialize();
        BackpackUpgradeRegistry.initialize();
        if (hasGeyserLoaded) {
            BackpackGeyser.initialize();
        }
        if (hasTrinketLoaded) {
            BackpackTrinket.initialize();
        }
        ServerBackpacks.serverEvents();
    }

    private static void serverEvents() {
        ServerPlayConnectionEvents.JOIN.register((serverPlayNetworkHandler, a, b) -> {
            class_3222 player = serverPlayNetworkHandler.method_32311();
            if (ServerBackpacks.isBedrock(player)) {
                BEDROCK_PLAYERS.add(player);
            }
        });
        ServerPlayConnectionEvents.DISCONNECT.register((serverPlayNetworkHandler, a) -> BEDROCK_PLAYERS.remove(serverPlayNetworkHandler.method_32311()));
        ServerLifecycleEvents.SERVER_STARTING.register(BackpackManager::setup);
        ServerLifecycleEvents.SERVER_STARTED.register(BackpackManager::loadOnServerStarted);
        ServerLifecycleEvents.SERVER_STOPPED.register(BackpackManager::destroy);
        ServerLifecycleEvents.BEFORE_SAVE.register((minecraftServer, b, b1) -> {
            if (BackpackManager.instance() != null) {
                BackpackManager.createBackup();
            }
        });
        Runtime.getRuntime().addShutdownHook(new Thread(BackpackData::shutdownThread));
        ServerBackpacks.backupEvents();
    }

    private static void backupEvents() {
        ServerPlayerEvents.LEAVE.register(p0 -> BackpackManager.createBackup());
        ServerPlayerEvents.AFTER_RESPAWN.register((p0, p1, p2) -> BackpackManager.createBackup());
    }

    public static boolean isBedrock(class_3222 player) {
        return hasGeyserLoaded && player != null && (BEDROCK_PLAYERS.contains(player) || BackpackGeyser.isPlayerOnBedrock(player));
    }
}

