/*
 * Decompiled with CFR 0.152.
 */
package com.rouesvm.servback.compat.geyser;

import com.rouesvm.servback.compat.geyser.BackpackGeyserBlock;
import com.rouesvm.servback.compat.geyser.BackpackGeyserItem;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_3222;
import org.geysermc.event.subscribe.Subscribe;
import org.geysermc.geyser.api.GeyserApi;
import org.geysermc.geyser.api.event.EventRegistrar;
import org.geysermc.geyser.api.event.lifecycle.GeyserDefineCustomBlocksEvent;
import org.geysermc.geyser.api.event.lifecycle.GeyserDefineCustomItemsEvent;
import org.geysermc.geyser.api.event.lifecycle.GeyserDefineResourcePacksEvent;
import org.geysermc.geyser.api.pack.PackCodec;
import org.geysermc.geyser.api.pack.ResourcePack;
import org.geysermc.geyser.api.pack.option.ResourcePackOption;

public class BackpackGeyser
implements EventRegistrar {
    public static Path PACKS_FOLDER;
    public static Path GEYSER_PACK;
    static GeyserApi geyser;

    public static void initialize() {
        BackpackGeyser.loadResourcePack();
        ServerLifecycleEvents.SERVER_STARTING.register(minecraftServer -> {
            geyser = GeyserApi.api();
            BackpackGeyser registrar = new BackpackGeyser();
            geyser.eventBus().register((Object)registrar, (Object)registrar);
            geyser.eventBus().subscribe((Object)registrar, GeyserDefineCustomBlocksEvent.class, BackpackGeyserBlock::onGeyserDefineCustomBlocksEvent);
            geyser.eventBus().subscribe((Object)registrar, GeyserDefineCustomItemsEvent.class, BackpackGeyserItem::onGeyserDefineCustomItemsEvent);
        });
    }

    public static void loadResourcePack() {
        PACKS_FOLDER = FabricLoader.getInstance().getConfigDir().resolve("serverbackpacks/");
        GEYSER_PACK = PACKS_FOLDER.resolve("backpack.zip");
        try {
            if (!PACKS_FOLDER.toFile().exists()) {
                Files.createDirectories(PACKS_FOLDER, new FileAttribute[0]);
            }
            Path file = (Path)FabricLoader.getInstance().getModContainer("serverbackpacks").flatMap(modContainer -> modContainer.findPath("bedrock/backpack.zip")).get();
            Files.copy(file, GEYSER_PACK, StandardCopyOption.REPLACE_EXISTING);
            GEYSER_PACK = PACKS_FOLDER.resolve("backpack.zip");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Subscribe
    public void onDefineResource(GeyserDefineResourcePacksEvent event) {
        if (GEYSER_PACK != null && GEYSER_PACK.toFile().exists()) {
            event.register(ResourcePack.create((PackCodec)PackCodec.path((Path)GEYSER_PACK)), new ResourcePackOption[0]);
        }
    }

    public static boolean isPlayerOnBedrock(class_3222 player) {
        if (geyser == null || player == null) {
            return false;
        }
        return geyser.isBedrockPlayer(player.method_5667());
    }
}

