/*
 * Decompiled with CFR 0.152.
 */
package com.rouesvm.servback.content.block.impl;

import com.rouesvm.servback.ServerBackpacks;
import com.rouesvm.servback.content.block.BasicBackpackBlockEntity;
import com.rouesvm.servback.content.block.TickableBlockEntity;
import com.rouesvm.servback.content.component.UpgradeContainerComponent;
import com.rouesvm.servback.content.upgrade.Upgrade;
import com.rouesvm.servback.registry.BackpackDataComponentTypes;
import com.rouesvm.servback.registry.block.BackpackBlockEntityRegistry;
import com.rouesvm.servback.technical.BackpackUtils;
import com.rouesvm.servback.technical.data.BackpackInstance;
import com.rouesvm.servback.technical.manager.BackpackManager;
import com.rouesvm.servback.technical.manager.BackpackUUID;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.fabricmc.fabric.api.transfer.v1.item.InventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.SlottedStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

public class BackpackBlockEntity
extends BasicBackpackBlockEntity
implements TickableBlockEntity {
    private UUID uuid;
    private int extraSize = 0;
    private BackpackInstance instance = null;
    private SlottedStorage<ItemVariant> storage;
    private List<Upgrade> upgradeList;

    public BackpackBlockEntity(class_2338 pos, class_2680 state) {
        super(BackpackBlockEntityRegistry.BACKPACK_BLOCK_ENTITY, pos, state);
    }

    @Override
    public void tick(class_1937 world, class_2338 pos, class_2680 state, class_2586 blockEntity) {
        if (this.uuid == null) {
            return;
        }
        if (this.upgradeList != null && !this.upgradeList.isEmpty()) {
            this.upgradeList.forEach(upgrade -> upgrade.tick(world, pos.method_46558(), this.instance.inventory()));
        }
    }

    @Override
    protected void method_11007(class_11372 view) {
        super.method_11007(view);
        view.method_71465("extraSize", this.extraSize);
        if (this.uuid != null) {
            view.method_71469("uuid", this.uuid.toString());
        }
        if (this.upgradeList != null) {
            view.method_71467("upgrade", UpgradeContainerComponent.CODEC).method_71484((Object)UpgradeContainerComponent.of(this.upgradeList));
        }
    }

    @Override
    protected void method_11014(class_11368 view) {
        super.method_11014(view);
        this.extraSize = view.method_71424("extraSize", 0);
        this.uuid = UUID.fromString(view.method_71428("uuid", BackpackUUID.generateUniqueUUID().toString()));
        class_11368.class_11369 upgradeContainer = view.method_71437("upgrade", UpgradeContainerComponent.CODEC);
        Optional upgradeContainerComponent = upgradeContainer.method_71456().findFirst();
        if (!upgradeContainer.method_71453() && upgradeContainerComponent.isPresent()) {
            this.upgradeList = ((UpgradeContainerComponent)upgradeContainerComponent.get()).getBaseUpgrades();
        }
        this.setStorage();
    }

    @Override
    public class_1799 getDefaultStack() {
        class_1799 stack = super.getDefaultStack();
        if (this.uuid == null) {
            return stack;
        }
        class_5455 registryManager = this.method_10997().method_30349();
        class_6880.class_6883 capacity = ((class_2378)registryManager.method_46759(class_7924.field_41265).get()).method_46747(ServerBackpacks.CAPACITY);
        stack.method_7978((class_6880)capacity, this.extraSize / 9);
        stack.method_57379(BackpackDataComponentTypes.BACKPACK_UUID, (Object)this.uuid);
        if (this.upgradeList != null) {
            stack.method_57379(BackpackDataComponentTypes.UPGRADE_CONTAINER, (Object)UpgradeContainerComponent.of(this.upgradeList));
        }
        BackpackUtils.addCustomData((class_3218)this.field_11863, stack);
        return stack;
    }

    public void setUpgradeList(List<Upgrade> upgradeList) {
        this.upgradeList = upgradeList;
    }

    public void setStorage() {
        if (this.instance == null) {
            this.instance = BackpackManager.getInstance(this.uuid, this.extraSize + this.getSize()).get();
        }
        if (this.storage == null) {
            this.instance.inventory().setEntity(this);
            this.storage = InventoryStorage.of((class_1263)this.instance.inventory(), null);
        }
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public void setUuid(UUID uuid) {
        this.uuid = uuid;
        if (this.instance == null) {
            this.setStorage();
        }
    }

    public BackpackInstance getInstance() {
        if (this.instance == null) {
            this.setStorage();
        }
        return this.instance;
    }

    public int getExtraSize() {
        return this.extraSize;
    }

    public void setExtraSize(int extraSize) {
        this.extraSize = extraSize;
    }

    @Nullable
    public Storage<ItemVariant> getInventoryProvider(@Nullable class_2350 ignoredDirection) {
        return this.storage;
    }
}

