/*
 * Decompiled with CFR 0.152.
 */
package com.rouesvm.servback.content.item.impl;

import com.rouesvm.servback.ServerBackpacks;
import com.rouesvm.servback.content.block.impl.BackpackBlockEntity;
import com.rouesvm.servback.content.component.UpgradeContainerComponent;
import com.rouesvm.servback.content.item.BundleGuiItem;
import com.rouesvm.servback.content.upgrade.Upgrade;
import com.rouesvm.servback.registry.BackpackDataComponentTypes;
import com.rouesvm.servback.registry.block.BackpackBlockRegistry;
import com.rouesvm.servback.technical.BackpackUtils;
import com.rouesvm.servback.technical.data.BackpackInstance;
import com.rouesvm.servback.technical.manager.BackpackManager;
import com.rouesvm.servback.technical.manager.BackpackUUID;
import com.rouesvm.servback.technical.ui.BackpackGui;
import com.rouesvm.servback.technical.ui.inventory.BackpackInventory;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_9288;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;
import xyz.nucleoid.packettweaker.PacketContext;

public class ContainerItem
extends BundleGuiItem {
    public final int slots;

    public ContainerItem(String name, int slots, class_2248 block) {
        super(name, block);
        this.slots = slots;
    }

    public ContainerItem(String name, int slots) {
        this(name, slots, BackpackBlockRegistry.BACKPACK);
    }

    public int getSize() {
        return this.slots;
    }

    public boolean method_31568() {
        return false;
    }

    @Override
    public void modifyClientTooltip(List<class_2561> tooltip, class_1799 polymerStack, PacketContext context) {
        UUID uuid = (UUID)polymerStack.method_58694(BackpackDataComponentTypes.BACKPACK_UUID);
        if (ServerBackpacks.isDevEnvironment && uuid != null) {
            tooltip.add(class_2561.method_30163((String)("UUID: " + String.valueOf(BackpackUUID.getStackUUID(polymerStack)))));
        }
        ContainerItem.addUpgradeTooltip(tooltip, polymerStack);
        ContainerItem.addInventoryTooltip(tooltip, polymerStack);
        super.modifyClientTooltip(tooltip, polymerStack, context);
    }

    public void method_7888(class_1799 stack, class_3218 world, class_1297 entity, @Nullable class_1304 slot) {
        if (entity instanceof class_3222) {
            class_3222 player = (class_3222)entity;
            UpgradeContainerComponent component = (UpgradeContainerComponent)stack.method_58694(BackpackDataComponentTypes.UPGRADE_CONTAINER);
            if (component != null) {
                component.getBaseUpgrades().forEach(upgrade -> upgrade.tick((class_1937)player.method_51469(), player.method_73189(), (BackpackInventory)this.getInventory(player, stack)));
            }
        }
    }

    @Override
    protected boolean method_7710(class_2338 pos, class_1937 world, @Nullable class_1657 player, class_1799 stack, class_2680 state) {
        class_2586 class_25862 = world.method_8321(pos);
        if (class_25862 instanceof BackpackBlockEntity) {
            UUID uuid;
            BackpackBlockEntity blockEntity = (BackpackBlockEntity)class_25862;
            BackpackUtils.resizeIfIncorrectSize((class_3222)player, stack, this.slots);
            blockEntity.setItem((class_1792)this);
            blockEntity.setSize(this.slots);
            blockEntity.setExtraSize(BackpackUtils.getExtendedSlots(stack));
            UpgradeContainerComponent component = (UpgradeContainerComponent)stack.method_58694(BackpackDataComponentTypes.UPGRADE_CONTAINER);
            if (component != null) {
                blockEntity.setUpgradeList(component.getBaseUpgrades());
            }
            if ((uuid = BackpackUUID.getStackUUID(stack)) == null) {
                uuid = BackpackUUID.createNewUUID(stack);
            }
            blockEntity.setUuid(uuid);
            blockEntity.setStorage();
            if (stack.method_65130() != null) {
                blockEntity.setCustomName(stack.method_65130());
            }
            blockEntity.method_5431();
            ContainerItem.playOpenSound((class_3222)player);
        }
        return ContainerItem.method_7714((class_1937)world, (class_1657)player, (class_2338)pos, (class_1799)stack);
    }

    @Override
    public class_1263 getInventory(@Nullable class_3222 player, @Nullable class_1799 stack) {
        return stack != null ? BackpackManager.getInventory(BackpackUUID.getStackUUID(stack)) : null;
    }

    @Override
    public void openGui(class_3222 player, class_1799 stack) {
        BackpackUUID.createNewUUID(stack);
        BackpackUtils.resizeIfIncorrectSize(player, stack, this.slots);
        Optional<BackpackInstance> instance = BackpackManager.getInstance(BackpackUUID.getStackUUID(stack), this.slots + BackpackUtils.getExtendedSlots(stack));
        instance.ifPresent(backpackInstance -> new BackpackGui(player, stack, (BackpackInstance)backpackInstance));
    }

    @Override
    public void afterChanged(class_1799 stack, class_1263 inventory) {
        UUID uuid = BackpackUUID.getStackUUID(stack);
        if (uuid != null) {
            BackpackManager.addBackpack(uuid, (BackpackInventory)inventory);
        }
    }

    public class_2371<class_1799> getComponentItemList(class_1799 stack) {
        class_2371 list = class_2371.method_10213((int)this.slots, (Object)class_1799.field_8037);
        ((class_9288)stack.method_58695(class_9334.field_49622, (Object)class_9288.field_49334)).method_57492(list);
        return list;
    }

    public static void addUpgradeTooltip(List<class_2561> tooltip, class_1799 stack) {
        UpgradeContainerComponent upgradeContainer = (UpgradeContainerComponent)stack.method_58694(BackpackDataComponentTypes.UPGRADE_CONTAINER);
        if (upgradeContainer == null) {
            return;
        }
        if (upgradeContainer.getBaseUpgrades().isEmpty()) {
            return;
        }
        tooltip.add((class_2561)class_2561.method_43471((String)"info.serverbackpacks.upgrades").method_27693(":").method_27692(class_124.field_1080));
        for (Upgrade upgrade : upgradeContainer.getBaseUpgrades()) {
            tooltip.add((class_2561)class_2561.method_43470((String)" ").method_10852(upgrade.getType().getTranslationKey()).method_27692(class_124.field_1077));
        }
    }

    public static void addInventoryTooltip(List<class_2561> tooltip, class_1799 stack) {
        class_2371<class_1799> itemList = BackpackUtils.getItemList(stack);
        if (itemList.isEmpty()) {
            return;
        }
        tooltip.add((class_2561)class_2561.method_43471((String)"info.serverbackpacks.contains").method_27693(":").method_27692(class_124.field_1080));
        int capacityMaxShow = 0;
        int capacityAmount = 0;
        for (class_1799 itemStack : itemList) {
            if (itemStack.method_7960()) continue;
            ++capacityAmount;
            if (capacityMaxShow > 4) continue;
            ++capacityMaxShow;
            tooltip.add((class_2561)class_2561.method_43470((String)" ").method_10852((class_2561)class_2561.method_43469((String)"item.container.item_count", (Object[])new Object[]{itemStack.method_7964(), itemStack.method_7947()})).method_27692(class_124.field_1062));
        }
        if (capacityAmount - capacityMaxShow > 0) {
            tooltip.add((class_2561)class_2561.method_43469((String)"item.container.more_items", (Object[])new Object[]{capacityAmount - capacityMaxShow}).method_27692(class_124.field_1056).method_27692(class_124.field_1062));
        }
    }

    public static void playOpenSound(class_3222 player) {
        player.method_17356(class_3417.field_34375, class_3419.field_15248, 0.8f, 0.8f + player.method_51469().method_8409().method_43057() * 0.4f);
        player.method_17356(class_3417.field_34376, class_3419.field_15248, 0.8f, 0.8f + player.method_51469().method_8409().method_43057() * 0.4f);
    }

    public static void playInsertSound(class_1937 world, class_2338 pos, float pitch) {
        world.method_8396(null, pos, class_3417.field_34376, class_3419.field_61058, 0.8f, pitch + world.method_8409().method_43057() * 0.4f);
    }

    public static void playInsertSound(class_3222 player, float pitch) {
        ContainerItem.playInsertSound((class_1937)player.method_51469(), player.method_24515(), pitch);
    }

    public static void playDropContentsSound(class_3222 player, float pitch) {
        player.method_17356(class_3417.field_34375, class_3419.field_15248, 0.8f, pitch + player.method_51469().method_8409().method_43057() * 0.4f);
    }

    public static void playInsertFailSound(class_3222 player) {
        player.method_17356(class_3417.field_52372, class_3419.field_15248, 1.0f, 1.0f);
    }
}

