/*
 * Decompiled with CFR 0.152.
 */
package com.rouesvm.servback.content.recipe.builder;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.rouesvm.servback.content.recipe.BackpackRecipe;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_161;
import net.minecraft.class_170;
import net.minecraft.class_175;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1935;
import net.minecraft.class_2119;
import net.minecraft.class_5321;
import net.minecraft.class_5797;
import net.minecraft.class_6862;
import net.minecraft.class_6885;
import net.minecraft.class_7800;
import net.minecraft.class_7871;
import net.minecraft.class_8782;
import net.minecraft.class_8790;
import net.minecraft.class_8957;
import org.jetbrains.annotations.Nullable;

public class BackpackRecipeJsonBuilder
implements class_5797 {
    private final class_7871<class_1792> registryLookup;
    private final class_7800 category;
    private final class_1792 output;
    private final int count;
    private final List<String> pattern = Lists.newArrayList();
    private final Map<Character, class_1856> inputs = Maps.newLinkedHashMap();
    private final Map<String, class_175<?>> criteria = new LinkedHashMap();
    @Nullable
    private String group;
    private final boolean showNotification = true;

    private BackpackRecipeJsonBuilder(class_7871<class_1792> registryLookup, class_7800 category, class_1935 output, int count) {
        this.registryLookup = registryLookup;
        this.category = category;
        this.output = output.method_8389();
        this.count = count;
    }

    public static BackpackRecipeJsonBuilder create(class_7871<class_1792> registryLookup, class_7800 category, class_1935 output) {
        return BackpackRecipeJsonBuilder.create(registryLookup, category, output, 1);
    }

    public static BackpackRecipeJsonBuilder create(class_7871<class_1792> registryLookup, class_7800 category, class_1935 output, int count) {
        return new BackpackRecipeJsonBuilder(registryLookup, category, output, count);
    }

    public BackpackRecipeJsonBuilder input(Character c, class_6862<class_1792> tag) {
        return this.input(c, class_1856.method_8106((class_6885)this.registryLookup.method_46735(tag)));
    }

    public BackpackRecipeJsonBuilder input(Character c, class_1935 item) {
        return this.input(c, class_1856.method_8101((class_1935)item));
    }

    public BackpackRecipeJsonBuilder input(Character c, class_1856 ingredient) {
        if (this.inputs.containsKey(c)) {
            throw new IllegalArgumentException("Symbol '" + c + "' is already defined!");
        }
        if (c.charValue() == ' ') {
            throw new IllegalArgumentException("Symbol ' ' (whitespace) is reserved and cannot be defined");
        }
        this.inputs.put(c, ingredient);
        return this;
    }

    public BackpackRecipeJsonBuilder pattern(String patternStr) {
        if (!this.pattern.isEmpty() && patternStr.length() != this.pattern.getFirst().length()) {
            throw new IllegalArgumentException("Pattern must be the same width on every line!");
        }
        this.pattern.add(patternStr);
        return this;
    }

    public BackpackRecipeJsonBuilder criterion(String string, class_175<?> advancementCriterion) {
        this.criteria.put(string, advancementCriterion);
        return this;
    }

    public BackpackRecipeJsonBuilder group(@Nullable String string) {
        this.group = string;
        return this;
    }

    public class_1792 method_36441() {
        return this.output;
    }

    public void method_17972(class_8790 exporter, class_5321<class_1860<?>> recipeKey) {
        class_8957 rawShapedRecipe = this.validate(recipeKey);
        class_161.class_162 builder = exporter.method_53818().method_705("has_the_recipe", class_2119.method_27847(recipeKey)).method_703(class_170.class_171.method_753(recipeKey)).method_704(class_8782.class_8797.field_1257);
        Objects.requireNonNull(builder);
        this.criteria.forEach((arg_0, arg_1) -> ((class_161.class_162)builder).method_705(arg_0, arg_1));
        BackpackRecipe shapedRecipe = new BackpackRecipe(Objects.requireNonNullElse(this.group, ""), class_5797.method_55308((class_7800)this.category), rawShapedRecipe, new class_1799((class_1935)this.output, this.count), this.showNotification);
        exporter.method_53819(recipeKey, (class_1860)shapedRecipe, builder.method_695(recipeKey.method_29177().method_45138("recipes/" + this.category.method_46203() + "/")));
    }

    private class_8957 validate(class_5321<class_1860<?>> recipeKey) {
        if (this.criteria.isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + String.valueOf(recipeKey.method_29177()));
        }
        return class_8957.method_55085(this.inputs, this.pattern);
    }
}

