/*
 * Decompiled with CFR 0.152.
 */
package com.rouesvm.servback.content.upgrade.extension;

import com.mojang.serialization.Codec;
import com.rouesvm.servback.content.upgrade.PersistentUpgrade;
import com.rouesvm.servback.technical.ui.inventory.BackpackInventory;
import java.util.Set;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7922;
import net.minecraft.class_7923;

public class ItemFilter
implements PersistentUpgrade {
    private MODE mode;
    private final Set<String> filterList;

    public ItemFilter(MODE mode, Set<String> filters) {
        this.mode = mode;
        this.filterList = filters;
    }

    public boolean matches(class_1799 stack) {
        return this.filterList.stream().anyMatch(filterID -> ItemFilter.matchesFilter(filterID, stack.method_7909()));
    }

    public boolean matches(class_1799 stack, BackpackInventory inventory) {
        return inventory.method_43256(inventoryStack -> inventoryStack.method_31574(stack.method_7909()));
    }

    public static boolean matchesFilter(String filterID, class_1792 item) {
        class_7922 itemRegistry = class_7923.field_41178;
        class_6880 itemEntry = itemRegistry.method_47983((Object)item);
        if (filterID.startsWith("#")) {
            class_2960 tagId = class_2960.method_12829((String)filterID.substring(1));
            if (tagId == null) {
                return false;
            }
            class_6862 tag = class_6862.method_40092((class_5321)itemRegistry.method_46765(), (class_2960)tagId);
            return itemEntry.method_40220(tag);
        }
        String itemId = itemEntry.method_55840();
        return itemId.equals(filterID);
    }

    @Override
    public void readView(class_11368 data) {
        this.mode = MODE.values()[data.method_71424("mode", 0)];
        class_11368.class_11369 listReadView = data.method_71437("Items", (Codec)Codec.STRING);
        listReadView.forEach(this.filterList::add);
    }

    @Override
    public void writeView(class_11372 data) {
        if (this.mode != null) {
            data.method_71465("mode", this.mode.ordinal());
        }
        class_11372.class_11373 listAppender = data.method_71467("Items", (Codec)Codec.STRING);
        this.filterList.stream().filter(string -> !string.isEmpty()).forEach(arg_0 -> ((class_11372.class_11373)listAppender).method_71484(arg_0));
        if (listAppender.method_71483()) {
            data.method_71478("Items");
        }
    }

    public Set<String> filterList() {
        return this.filterList;
    }

    public MODE getMode() {
        return this.mode;
    }

    public void setMode(MODE mode) {
        this.mode = mode;
    }

    public static enum MODE {
        BLACKLIST,
        WHITELIST,
        MATCH_CONTENT,
        PICKUP;

    }
}

