/*
 * Decompiled with CFR 0.152.
 */
package com.rouesvm.servback.content.upgrade.impl;

import com.rouesvm.servback.content.upgrade.FilterableUpgrade;
import com.rouesvm.servback.content.upgrade.PersistentUpgrade;
import com.rouesvm.servback.content.upgrade.Upgrade;
import com.rouesvm.servback.content.upgrade.extension.ItemFilter;
import com.rouesvm.servback.registry.BackpackUpgradeRegistry;
import com.rouesvm.servback.technical.ui.inventory.BackpackInventory;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_124;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import xyz.nucleoid.packettweaker.PacketContext;

public class VoidUpgrade
extends Upgrade
implements PersistentUpgrade,
FilterableUpgrade {
    public static final double MAX_RANGE = 2.5;
    public static final double MAX_ITEM_ENTITY_DISTANCE_TO_PLAYER = 0.75;
    public static final double MAX_DISTANCE_TO_PLAYER_SQUARED = 1.5625;
    private int tick = 0;
    private final Set<class_1542> queue = new HashSet<class_1542>();
    private final ItemFilter itemFilter = new ItemFilter(ItemFilter.MODE.PICKUP, (Set<String>)new ObjectOpenHashSet(5));

    public VoidUpgrade() {
        super(BackpackUpgradeRegistry.VOID);
    }

    @Override
    public ItemFilter getFilter() {
        return this.itemFilter;
    }

    @Override
    public void readView(class_11368 data) {
        this.itemFilter.readView(data);
    }

    @Override
    public void writeView(class_11372 data) {
        this.itemFilter.writeView(data);
    }

    @Override
    public void addTooltip(List<class_2561> tooltip, class_1799 stack, PacketContext context) {
        if (this.itemFilter.filterList().isEmpty()) {
            return;
        }
        tooltip.add((class_2561)class_2561.method_43471((String)"info.serverbackpacks.contains").method_27692(class_124.field_1080));
        for (String string : this.itemFilter.filterList()) {
            tooltip.add((class_2561)class_2561.method_43470((String)" ").method_27693(string).method_27661().method_27692(class_124.field_1062));
        }
    }

    @Override
    public void tick(class_1937 world, class_243 pos, BackpackInventory inventory) {
        if (inventory == null || !(world instanceof class_3218)) {
            return;
        }
        class_3218 serverWorld = (class_3218)world;
        ++this.tick;
        this.moveItemsToTarget(pos);
        if (!this.voidItems(pos, inventory)) {
            this.checkForItems(serverWorld, pos, inventory);
        }
    }

    private void moveItemsToTarget(class_243 pos) {
        if (this.queue.isEmpty()) {
            return;
        }
        class_243 target = new class_243(pos.method_46409());
        this.queue.forEach(item -> {
            class_243 current = item.method_73189();
            class_243 delta = target.method_1020(current);
            double distance = delta.method_1033();
            if (distance >= 0.75) {
                double speed = Math.min(0.6, distance * 0.8);
                class_243 velocity = delta.method_1029().method_1021(speed);
                class_243 smooth = item.method_18798().method_35590(velocity, 0.4);
                item.method_18799(smooth);
            } else {
                item.method_18799(class_243.field_1353);
            }
            item.field_6037 = true;
            item.method_6982(100);
        });
    }

    private boolean voidItems(class_243 pos, BackpackInventory inventory) {
        if (this.queue.isEmpty()) {
            return false;
        }
        if (BackpackInventory.isFull(inventory)) {
            this.queue.forEach(entity -> entity.method_6982(0));
            return false;
        }
        if (this.tick % 4 == 0) {
            Iterator<class_1542> iterator = this.queue.iterator();
            if (!iterator.hasNext()) {
                return false;
            }
            class_1542 next = iterator.next();
            if (next == null || !next.method_5805() || next.method_5707(pos) > 2.5) {
                iterator.remove();
                return false;
            }
            if (next.method_5707(pos) > 1.5625) {
                return false;
            }
            next.method_6987();
        }
        return true;
    }

    private void checkForItems(class_3218 world, class_243 pos, BackpackInventory inventory) {
        class_238 area = new class_238(pos.method_61889(-2.5), pos.method_61889(2.5));
        world.method_8390(class_1542.class, area, entity -> !this.queue.contains(entity) && inventory.canInsert(entity.method_6983()) && this.checkFilterForItem((class_1542)entity)).forEach(item -> {
            this.queue.add((class_1542)item);
            item.method_6982(100);
        });
    }

    private boolean checkFilterForItem(class_1542 entity) {
        if (!entity.method_5805()) {
            return false;
        }
        class_1799 stack = entity.method_6983();
        return this.itemFilter.matches(stack);
    }
}

