/*
 * Decompiled with CFR 0.152.
 */
package com.rouesvm.servback.technical.config.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandExceptionType;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.rouesvm.servback.ServerBackpacks;
import com.rouesvm.servback.technical.config.Configuration;
import com.rouesvm.servback.technical.config.commands.TrinketsBackpack;
import com.rouesvm.servback.technical.data.BackpackInstance;
import com.rouesvm.servback.technical.manager.BackpackManager;
import com.rouesvm.servback.technical.ui.BackpackGui;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2561;

public class BackpackCommands {
    public static void initialize() {
        CommandRegistrationCallback.EVENT.register((dispatcher, a, b) -> BackpackCommands.init((CommandDispatcher<class_2168>)dispatcher));
    }

    public static void init(CommandDispatcher<class_2168> dispatcher) {
        if (ServerBackpacks.hasTrinketLoaded) {
            TrinketsBackpack.initialize(dispatcher);
        }
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"backpacks").requires(source -> Permissions.check((class_2172)source, (String)"serverbackpacks.command", (int)4))).executes(context -> {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Server Backpacks! by Rouesvm"), false);
            return 1;
        })).then(class_2170.method_9247((String)"backup").executes(context -> {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43471((String)"command.serverbackpacks.backup"), false);
            BackpackManager.createBackup();
            return 1;
        }))).then(class_2170.method_9247((String)"list").executes(context -> {
            Set<UUID> instances = BackpackManager.instance().storedInstances().keySet();
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43471((String)"command.serverbackpacks.list"), false);
            for (UUID uuid : instances) {
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)String.format("(%s)", uuid.toString())), false);
            }
            return 1;
        }))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"open").then(class_2170.method_9244((String)"uuid", (ArgumentType)StringArgumentType.word()).executes(context -> {
            Optional<BackpackInstance> instance;
            String search = StringArgumentType.getString((CommandContext)context, (String)"uuid");
            if (!search.isEmpty()) {
                if (search.length() != 36) {
                    throw new CommandSyntaxException((CommandExceptionType)CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherParseException(), (Message)class_2561.method_43471((String)"command.serverbackpacks.incorrect_uuid"));
                }
                UUID uuid = UUID.fromString(search);
                instance = BackpackManager.getInstance(uuid);
                if (!instance.isPresent()) {
                    throw new CommandSyntaxException((CommandExceptionType)CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherParseException(), (Message)class_2561.method_43471((String)"command.serverbackpacks.incorrect_uuid"));
                }
            } else {
                throw new CommandSyntaxException((CommandExceptionType)CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownArgument(), (Message)class_2561.method_43471((String)"command.serverbackpacks.empty"));
            }
            new BackpackGui(((class_2168)context.getSource()).method_44023(), instance.get());
            return 1;
        }))).then(BackpackCommands.configCommand())));
    }

    private static LiteralArgumentBuilder<class_2168> configCommand() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"config").then(class_2170.method_9247((String)"reset").executes(context -> {
            Configuration.manager.instance = new Configuration.Instance();
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43471((String)"command.serverbackpacks.reset"), true);
            return 1;
        }))).then(class_2170.method_9247((String)"reload").executes(context -> {
            Configuration.manager.load();
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43471((String)"command.serverbackpacks.reload"), true);
            return 1;
        }))).then(class_2170.method_9247((String)"save").executes(context -> {
            Configuration.manager.save();
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43471((String)"command.serverbackpacks.save"), true);
            return 1;
        }));
    }
}

