/*
 * Decompiled with CFR 0.152.
 */
package com.rouesvm.servback.technical.cosmetic;

import com.rouesvm.servback.content.item.impl.ContainerItem;
import com.rouesvm.servback.registry.item.BackpackItemJsonRegistry;
import com.rouesvm.servback.technical.config.BackpackItemConfiguration;
import com.rouesvm.servback.technical.cosmetic.BackInterface;
import eu.pb4.polymer.virtualentity.api.ElementHolder;
import eu.pb4.polymer.virtualentity.api.VirtualEntityUtils;
import eu.pb4.polymer.virtualentity.api.attachment.EntityAttachment;
import eu.pb4.polymer.virtualentity.api.elements.ItemDisplayElement;
import eu.pb4.polymer.virtualentity.api.elements.VirtualElement;
import eu.pb4.polymer.virtualentity.impl.EntityExt;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2596;
import net.minecraft.class_2716;
import net.minecraft.class_2752;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_4050;
import net.minecraft.class_8042;
import net.minecraft.class_9280;
import net.minecraft.class_9334;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class BackHolder
extends ElementHolder {
    private final class_1309 entity;
    private final ItemDisplayElement element;
    private final Vector3f position = new Vector3f();
    private Vector3f cosmeticPosition = new Vector3f(0.0f, -0.65f, 0.28f);
    private Integer cosmeticRotation = 180;
    private Integer cosmeticPitchWhenSneaking = -25;
    private boolean hidden;

    private BackHolder(class_1799 stack, class_1309 entity) {
        this.entity = entity;
        this.element = new ItemDisplayElement();
        class_9280 component = new class_9280(List.of(), List.of(), List.of("model"), List.of());
        stack.method_57379(class_9334.field_49637, (Object)component);
        this.element.setItem(stack);
        this.element.setTranslation((Vector3fc)new Vector3f(0.0f, 0.25f, 0.0f));
        this.element.setScale((Vector3fc)new Vector3f(0.875f));
        this.element.setTeleportDuration(1);
        this.element.ignorePositionUpdates();
        class_1792 class_17922 = this.element.getItem().method_7909();
        if (class_17922 instanceof ContainerItem) {
            ContainerItem item = (ContainerItem)class_17922;
            BackpackItemConfiguration.BackCosmetic order = BackpackItemJsonRegistry.getBackpackCosmetic(item);
            this.cosmeticPosition = order.offset();
            this.cosmeticRotation = order.yaw();
            this.cosmeticPitchWhenSneaking = order.pitch_while_sneaking();
        }
        this.addElement((VirtualElement)this.element);
    }

    protected void onTick() {
        boolean isHiddenPose;
        class_3222 serverPlayer;
        if (this.entity.method_29504() || this.entity.method_31481()) {
            this.destroy();
        }
        boolean facingDown = this.entity.method_58149() == class_2350.field_11033;
        class_1309 class_13092 = this.entity;
        boolean isSpectator = class_13092 instanceof class_3222 && (serverPlayer = (class_3222)class_13092).method_7325();
        class_4050 pose = this.entity.method_18376();
        boolean bl = isHiddenPose = facingDown || pose == class_4050.field_18079 || pose == class_4050.field_18078 || isSpectator;
        if (isHiddenPose) {
            if (!this.hidden) {
                BackHolder.hideForAll(this);
                this.hidden = true;
            }
        } else {
            float z;
            if (this.hidden) {
                BackHolder.showForAll(this);
                this.updatePosition();
                this.sendRidePacket();
                this.hidden = false;
            }
            boolean sneaking = this.entity.method_5715();
            this.element.setYaw(((BackInterface)this.entity).backpacks$bodyYaw() - (float)this.cosmeticRotation.intValue());
            this.element.setPitch(sneaking ? (float)this.cosmeticPitchWhenSneaking.intValue() : 0.0f);
            float y = sneaking ? this.cosmeticPosition.y - 0.02f : this.cosmeticPosition.y;
            float f = z = sneaking ? this.cosmeticPosition.z - 0.1f : this.cosmeticPosition.z;
            if (!this.entity.method_6118(class_1304.field_6174).method_7960()) {
                z += 0.05f;
            }
            this.position.set(0.0f, y, z);
            this.element.setTranslation((Vector3fc)this.position);
        }
    }

    private void sendRidePacket() {
        class_2752 packet = VirtualEntityUtils.createRidePacket((int)this.entity.method_5628(), (IntList)((EntityExt)this.entity).polymerVE$getVirtualRidden());
        this.sendPacket((class_2596)packet);
    }

    protected void notifyElementsOfPositionUpdate(class_243 newPos, class_243 delta) {
    }

    public static BackHolder createDisplay(class_1799 stack, class_3222 entity) {
        BackHolder model = new BackHolder(stack.method_7972(), (class_1309)entity);
        EntityAttachment.ofTicking((ElementHolder)model, (class_1297)entity);
        model.startWatching(entity);
        VirtualEntityUtils.addVirtualPassenger((class_1297)entity, (int[])model.getEntityIds().toIntArray());
        class_2752 packet = VirtualEntityUtils.createRidePacket((int)entity.method_5628(), (IntList)((EntityExt)entity).polymerVE$getVirtualRidden());
        model.sendPacket((class_2596)packet);
        return model;
    }

    public static void hideForAll(ElementHolder elementHolder) {
        for (class_3244 player : elementHolder.getWatchingPlayers()) {
            player.method_14364((class_2596)new class_2716(elementHolder.getEntityIds()));
        }
    }

    public static void showForAll(ElementHolder elementHolder) {
        for (class_3244 player : elementHolder.getWatchingPlayers()) {
            ObjectArrayList packets = new ObjectArrayList();
            for (VirtualElement e : elementHolder.getElements()) {
                Objects.requireNonNull(packets);
                e.startWatching(player.field_14140, arg_0 -> ((ObjectArrayList)packets).add(arg_0));
            }
            player.method_14364((class_2596)new class_8042((Iterable)packets));
        }
    }
}

