/*
 * Decompiled with CFR 0.152.
 */
package com.rouesvm.servback.technical.data;

import com.mojang.datafixers.DataFixer;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.rouesvm.servback.ServerBackpacks;
import com.rouesvm.servback.technical.BackpackUtils;
import com.rouesvm.servback.technical.config.Configuration;
import com.rouesvm.servback.technical.data.BackpackInstance;
import com.rouesvm.servback.technical.data.codecs.BackpackInstanceData;
import com.rouesvm.servback.technical.data.codecs.InventoryData;
import com.rouesvm.servback.technical.manager.BackpackManager;
import com.rouesvm.servback.technical.ui.inventory.BackpackInventory;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import net.minecraft.class_1208;
import net.minecraft.class_155;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_5218;
import net.minecraft.class_8911;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

public class BackpackData {
    private static final ExecutorService executor = Executors.newSingleThreadExecutor(r -> {
        Thread t = new Thread(r, "ServerBackpacks-Data");
        t.setDaemon(true);
        return t;
    });
    private static Path singularBackupDir;
    private static Path fullBackupDir;
    private static Path saveDir;
    private static final Map<UUID, String> lastSingularHashes;
    private static final Map<UUID, String> lastFullHashes;
    private static final Set<BackpackInstance> storedInventories;
    private static final DateTimeFormatter formatter;

    public static void shutdownThread() {
        executor.shutdown();
        try {
            if (executor.awaitTermination(30L, TimeUnit.SECONDS)) {
                ServerBackpacks.LOGGER.info("Thread stopped.");
            }
        }
        catch (InterruptedException e) {
            ServerBackpacks.LOGGER.error("Error while stopping thread {}", (Object)e.getMessage());
        }
    }

    public static void createBackupDirs(MinecraftServer server) {
        Path backupDir = server.method_27050(class_5218.field_24188).resolve("data/backpacks-backups");
        try {
            Files.createDirectories(backupDir, new FileAttribute[0]);
        }
        catch (IOException e) {
            ServerBackpacks.LOGGER.error("Failed to create backup directory", (Throwable)e);
        }
        singularBackupDir = backupDir.resolve("singular");
        fullBackupDir = backupDir.resolve("full");
        try {
            Files.createDirectories(singularBackupDir, new FileAttribute[0]);
            Files.createDirectories(fullBackupDir, new FileAttribute[0]);
        }
        catch (IOException e) {
            ServerBackpacks.LOGGER.error("Failed to create singular/full backup directories", (Throwable)e);
        }
    }

    public static boolean loadData(MinecraftServer server, boolean hasLoaded) {
        if (!hasLoaded) {
            hasLoaded = BackpackData.loadData(server);
            Set<BackpackInstance> dataInstances = BackpackData.getBackpackInstances();
            if (hasLoaded && !dataInstances.isEmpty()) {
                BackpackManager.instance().loadIntoStoredInstances(dataInstances);
                return true;
            }
        }
        return false;
    }

    private static boolean loadData(MinecraftServer server) {
        saveDir = server.method_27050(class_5218.field_24188).resolve("data/backpacks");
        try {
            Files.createDirectories(saveDir, new FileAttribute[0]);
        }
        catch (IOException e) {
            ServerBackpacks.LOGGER.error("Failed to create instance directory", (Throwable)e);
            return false;
        }
        if (Files.exists(saveDir, new LinkOption[0])) {
            List<BackpackInstance> instances = BackpackData.loadExistingData(saveDir, server);
            if (instances != null && !instances.isEmpty()) {
                storedInventories.addAll(instances);
            }
            return instances != null && !instances.isEmpty();
        }
        BackpackData.save(server);
        return false;
    }

    private static void applyDataFixToItemStacks(@NotNull MinecraftServer server, class_2487 root, int newVersion) {
        DataFixer fixer = server.method_3855();
        Optional data_version = root.method_10550("data_version");
        if (data_version.isEmpty()) {
            return;
        }
        Optional contents = root.method_10562("contents");
        if (contents.isEmpty()) {
            return;
        }
        Optional items = ((class_2487)contents.get()).method_10554("Items");
        if (items.isEmpty()) {
            return;
        }
        class_2499 itemList = (class_2499)items.get();
        for (int j = 0; j < itemList.size(); ++j) {
            class_2487 slot;
            Optional wrapped;
            Optional slotCompound = itemList.method_10602(j);
            if (slotCompound.isEmpty() || (wrapped = (slot = (class_2487)slotCompound.get()).method_10562("itemStacks")).isEmpty()) continue;
            Dynamic inputDynamic = new Dynamic((DynamicOps)class_2509.field_11560, (Object)((class_2520)wrapped.get()));
            Dynamic outputDynamic = fixer.update(class_1208.field_5712, inputDynamic, ((Integer)data_version.get()).intValue(), newVersion);
            class_2487 fixed = (class_2487)outputDynamic.getValue();
            slot.method_10566("itemStacks", (class_2520)fixed);
        }
    }

    private static Optional<BackpackInstance> loadSingle(Path saveDir, MinecraftServer server, UUID uuid) {
        Optional<BackpackInstance> optional;
        if (saveDir == null) {
            return Optional.empty();
        }
        Path file = saveDir.resolve(uuid.toString() + ".dat");
        if (!Files.exists(file, new LinkOption[0])) {
            return Optional.empty();
        }
        DataInputStream dis = new DataInputStream(Files.newInputStream(file, new OpenOption[0]));
        try {
            class_2487 nbt = class_2507.method_10629((InputStream)dis, (class_2505)class_2505.method_53898());
            BackpackData.applyDataFixToItemStacks(server, nbt, class_155.method_16673().comp_4026().comp_4038());
            DataResult data = BackpackInstanceData.CODEC.decode((DynamicOps)server.method_30611().method_57093((DynamicOps)class_2509.field_11560), (Object)nbt);
            optional = data.result().map(pair -> BackpackData.turnDataToInstance((BackpackInstanceData)pair.getFirst()));
        }
        catch (Throwable throwable) {
            try {
                try {
                    dis.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | class_8911 e) {
                ServerBackpacks.LOGGER.error("Failed to load single backpack {}", (Object)uuid, (Object)e);
                return Optional.empty();
            }
        }
        dis.close();
        return optional;
    }

    public static void saveSingle(Path saveDir, MinecraftServer server, BackpackInstance instance) {
        block13: {
            if (!Files.exists(saveDir, new LinkOption[0])) {
                try {
                    Files.createDirectories(saveDir, new FileAttribute[0]);
                }
                catch (IOException e) {
                    ServerBackpacks.LOGGER.error("Error while creating directory {}", (Object)e.getMessage());
                }
            }
            Path targetFile = saveDir.resolve(String.valueOf(instance.uuid()) + ".dat");
            Path tempFile = saveDir.resolve(String.valueOf(instance.uuid()) + ".dat.tmp");
            try {
                DataResult data = BackpackInstanceData.CODEC.encodeStart((DynamicOps)server.method_30611().method_57093((DynamicOps)class_2509.field_11560), (Object)BackpackData.turnInstanceToData(instance));
                Optional result = data.result();
                if (!result.isPresent() || !((class_2520)result.get()).method_68571().isPresent()) break block13;
                try (OutputStream os = Files.newOutputStream(tempFile, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
                    class_2507.method_10634((class_2487)((class_2487)((class_2520)result.get()).method_68571().get()), (OutputStream)os);
                }
                Files.move(tempFile, targetFile, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
            }
            catch (IOException e) {
                ServerBackpacks.LOGGER.error("Failed to save backpack {}: {}", (Object)instance.uuid(), (Object)e.getMessage());
                try {
                    Files.deleteIfExists(tempFile);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    public static void saveSingle(MinecraftServer server, BackpackInstance instance) {
        BackpackData.saveSingle(saveDir, server, instance);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List<BackpackInstance> loadExistingData(Path saveDir, MinecraftServer server) {
        try (Stream<Path> paths = Files.walk(saveDir, new FileVisitOption[0]);){
            ArrayList uuids = new ArrayList();
            paths.filter(path -> path.toString().endsWith(".dat")).forEach(path -> uuids.add(UUID.fromString(path.getFileName().toString().replace(".dat", ""))));
            if (uuids.isEmpty()) {
                List<BackpackInstance> list = null;
                return list;
            }
            ArrayList instances = new ArrayList(uuids.size());
            for (UUID uuid : uuids) {
                Optional<BackpackInstance> instance = BackpackData.loadSingle(saveDir, server, uuid);
                instance.ifPresent(instances::add);
            }
            ArrayList arrayList = instances;
            return arrayList;
        }
        catch (IOException e) {
            ServerBackpacks.LOGGER.error("Failed to load Server Backpack's instance", (Throwable)e);
            return null;
        }
    }

    public static void save(MinecraftServer server) {
        executor.execute(() -> {
            for (BackpackInstance instance : storedInventories) {
                BackpackData.saveSingle(server, instance);
            }
            ServerBackpacks.LOGGER.info("Saving data for Server Backpacks.");
        });
    }

    private static Path createTimestampedDir(Path baseDir) {
        String formattedTime = LocalDateTime.now().format(formatter);
        return baseDir.resolve(formattedTime);
    }

    private static void saveBackup(Path dir, MinecraftServer server, BackpackInstance instance, Map<UUID, String> lastHashes) {
        UUID uuid = instance.uuid();
        String hash = BackpackUtils.hashBackpackContents(instance.heldInventory());
        if (!hash.equals(lastHashes.get(uuid))) {
            BackpackData.saveSingle(dir, server, instance);
            lastHashes.put(uuid, hash);
        }
    }

    public static void createSingularBackup(MinecraftServer server, BackpackInstance instance) {
        if (singularBackupDir == null || !Configuration.instance().allow_backups) {
            return;
        }
        BackpackData.replaceStoredInventory(instance);
        executor.execute(() -> BackpackData.saveBackup(BackpackData.createTimestampedDir(singularBackupDir), server, instance, lastSingularHashes));
    }

    public static void createBackup(MinecraftServer server) {
        if (fullBackupDir == null || !Configuration.instance().allow_backups) {
            return;
        }
        BackpackData.replaceStoredInventories(BackpackManager.instance().backpackInstances());
        executor.execute(() -> {
            Path currentDir = BackpackData.createTimestampedDir(fullBackupDir);
            for (BackpackInstance instance : storedInventories) {
                BackpackData.saveBackup(currentDir, server, instance, lastFullHashes);
            }
        });
    }

    public static BackpackInstanceData turnInstanceToData(BackpackInstance instance) {
        return new BackpackInstanceData(instance.uuid(), InventoryData.stacksListToData(instance.heldInventory()), Optional.of(instance.lastAccessed()), Optional.of(instance.size()), Optional.of(class_155.method_16673().comp_4026().comp_4038()));
    }

    public static BackpackInstance turnDataToInstance(BackpackInstanceData instance) {
        long lastAccessed = instance.last_accessed().orElse(System.currentTimeMillis());
        int size = instance.size().orElse(54);
        return new BackpackInstance(instance.uuid(), new BackpackInventory(InventoryData.getHeldStacks(instance.getInventoryData().itemStacks(), size)), lastAccessed);
    }

    public static Set<BackpackInstance> getBackpackInstances() {
        return storedInventories;
    }

    public static void replaceStoredInventory(BackpackInstance backpackInstance) {
        storedInventories.add(backpackInstance);
    }

    public static void replaceStoredInventories(Set<BackpackInstance> backpackInstances) {
        storedInventories.clear();
        storedInventories.addAll(backpackInstances);
    }

    static {
        lastSingularHashes = new Object2ObjectOpenHashMap();
        lastFullHashes = new Object2ObjectOpenHashMap();
        storedInventories = Collections.synchronizedSet(new ObjectOpenHashSet());
        formatter = DateTimeFormatter.ofPattern("dd-MM-yyyy-HH-mm-ss");
    }
}

