/*
 * Decompiled with CFR 0.152.
 */
package com.rouesvm.servback.technical.data.alternative;

import com.mojang.datafixers.DataFixer;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.rouesvm.servback.ServerBackpacks;
import com.rouesvm.servback.technical.data.BackpackData;
import com.rouesvm.servback.technical.data.BackpackInstance;
import com.rouesvm.servback.technical.data.codecs.BackpackInstanceData;
import com.rouesvm.servback.technical.manager.BackpackManager;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_1208;
import net.minecraft.class_155;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2507;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_5218;
import net.minecraft.class_6903;
import net.minecraft.server.MinecraftServer;

public class BackpackListData {
    private static List<BackpackInstanceData> storedInventories = new ArrayList<BackpackInstanceData>();
    private static final Codec<List<BackpackInstanceData>> SAVE_CODEC = BackpackInstanceData.CODEC.listOf().fieldOf("backpackContents").codec();
    private static Path saveDir;

    public static Set<BackpackInstance> getBackpackInstances() {
        return storedInventories.stream().map(BackpackData::turnDataToInstance).collect(Collectors.toSet());
    }

    public static boolean loadData(MinecraftServer server, boolean hasLoaded) {
        if (!hasLoaded) {
            saveDir = server.method_27050(class_5218.field_24188).resolve("data/serverbackpacks.data");
            try {
                hasLoaded = BackpackListData.loadExistingData(server);
            }
            catch (IOException e) {
                ServerBackpacks.LOGGER.error("Error while loading list data {}", (Object)e.getMessage());
            }
            if (hasLoaded) {
                Set<BackpackInstance> dataInstances = BackpackListData.getBackpackInstances();
                ServerBackpacks.LOGGER.info("Successfully loaded list data!");
                if (!dataInstances.isEmpty()) {
                    BackpackManager.instance().loadIntoStoredInstances(dataInstances);
                    return true;
                }
            }
        }
        return false;
    }

    private static void applyFixToNestedItemStacks(MinecraftServer server, class_2487 root, int oldVersion, int newVersion) {
        DataFixer fixer = server.method_3855();
        Optional backpacksOptional = root.method_10554("backpackContents");
        if (backpacksOptional.isEmpty()) {
            return;
        }
        class_2499 backpacks = (class_2499)backpacksOptional.get();
        for (int i = 0; i < backpacks.size(); ++i) {
            Optional items;
            Optional contents;
            Optional backpackEntry = backpacks.method_10602(i);
            if (backpackEntry.isEmpty() || (contents = ((class_2487)backpackEntry.get()).method_10562("contents")).isEmpty() || (items = ((class_2487)contents.get()).method_10554("Items")).isEmpty()) continue;
            class_2499 itemList = (class_2499)items.get();
            for (int j = 0; j < itemList.size(); ++j) {
                class_2487 slot;
                Optional wrapped;
                Optional slotCompound = itemList.method_10602(j);
                if (slotCompound.isEmpty() || (wrapped = (slot = (class_2487)slotCompound.get()).method_10562("itemStacks")).isEmpty()) continue;
                Dynamic inputDynamic = new Dynamic((DynamicOps)class_2509.field_11560, (Object)((class_2520)wrapped.get()));
                Dynamic outputDynamic = fixer.update(class_1208.field_5712, inputDynamic, oldVersion, newVersion);
                class_2487 fixed = (class_2487)outputDynamic.getValue();
                slot.method_10566("itemStacks", (class_2520)fixed);
            }
        }
    }

    private static boolean loadExistingData(MinecraftServer server) throws IOException {
        try (DataInputStream dis = new DataInputStream(Files.newInputStream(saveDir, new OpenOption[0]));){
            class_2487 compound = class_2507.method_10627((DataInput)dis);
            int newDataVersion = class_155.method_16673().comp_4026().comp_4038();
            int oldDataVersion = 4440;
            BackpackListData.applyFixToNestedItemStacks(server, compound, oldDataVersion, newDataVersion);
            class_6903 ops = server.method_30611().method_57093((DynamicOps)class_2509.field_11560);
            DataResult dataResult = SAVE_CODEC.decode((DynamicOps)ops, (Object)compound);
            dataResult.error().ifPresent(err -> {
                ServerBackpacks.LOGGER.error("SAVE_CODEC.decode failed: {}", (Object)err.message());
                err.error().ifPresent(e -> ServerBackpacks.LOGGER.error("Decode exception: {}", (Object)e.message()));
            });
            Optional result = dataResult.result();
            if (result.isPresent()) {
                Pair pair = (Pair)result.get();
                storedInventories = (List)pair.getFirst();
            } else {
                storedInventories = new ArrayList<BackpackInstanceData>();
            }
            boolean bl = !storedInventories.isEmpty();
            return bl;
        }
    }
}

