/*
 * Decompiled with CFR 0.152.
 */
package com.rouesvm.servback.technical.data.alternative;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.rouesvm.servback.technical.data.BackpackData;
import com.rouesvm.servback.technical.data.BackpackInstance;
import com.rouesvm.servback.technical.data.codecs.BackpackInstanceData;
import com.rouesvm.servback.technical.manager.BackpackManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_10741;
import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_26;
import net.minecraft.server.MinecraftServer;

public class BackpackState
extends class_18 {
    public final Set<BackpackInstanceData> storedInventories = new HashSet<BackpackInstanceData>();
    private static final Codec<BackpackState> SAVE_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BackpackInstanceData.CODEC.listOf().fieldOf("backpackContents").forGetter(BackpackState::getStoredInventories)).apply((Applicative)instance, BackpackState::new));
    private static final class_10741<BackpackState> type = new class_10741("serverbackpacks-v2", BackpackState::new, SAVE_CODEC, null);

    public BackpackState(List<BackpackInstanceData> data) {
        this.storedInventories.addAll(data);
    }

    public BackpackState() {
        this(Collections.emptyList());
    }

    public static boolean loadData(MinecraftServer server, boolean hasLoaded) {
        BackpackState state = BackpackState.getServerState(server);
        if (!hasLoaded && state != null) {
            return BackpackState.loadData(state);
        }
        return false;
    }

    private static boolean loadData(BackpackState state) {
        Set<BackpackInstance> stateInstances = state.getBackpackInstances();
        if (stateInstances != null && !stateInstances.isEmpty()) {
            BackpackManager.instance().loadIntoStoredInstances(stateInstances);
            state.clearBackpackInstances();
            state.method_80();
            return true;
        }
        return false;
    }

    private static BackpackState getServerState(MinecraftServer server) {
        if (server.method_3847(class_1937.field_25179) == null) {
            return null;
        }
        class_26 persistentStateManager = server.method_3847(class_1937.field_25179).method_17983();
        BackpackState state = (BackpackState)persistentStateManager.method_17924(type);
        state.method_80();
        return state;
    }

    private List<BackpackInstanceData> getStoredInventories() {
        return new ArrayList<BackpackInstanceData>(this.storedInventories);
    }

    private void clearBackpackInstances() {
        this.storedInventories.clear();
    }

    private Set<BackpackInstance> getBackpackInstances() {
        return this.storedInventories.stream().map(BackpackData::turnDataToInstance).collect(Collectors.toSet());
    }
}

