/*
 * Decompiled with CFR 0.152.
 */
package com.rouesvm.servback.technical.ui;

import com.mojang.brigadier.Message;
import com.rouesvm.servback.ServerBackpacks;
import com.rouesvm.servback.registry.BackpackDataComponentTypes;
import com.rouesvm.servback.technical.ui.slots.NonBackpackSlot;
import eu.pb4.sgui.api.gui.SimpleGui;
import net.minecraft.class_1263;
import net.minecraft.class_1703;
import net.minecraft.class_1712;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3917;
import net.minecraft.class_5250;

public class BasicInventoryGui
extends SimpleGui {
    private static final String BEDROCK_ROW_MARKER = "chest.row.";
    private static final int EXISTING_SMALL_CHEST_SIZE = 27;
    private static final int EXISTING_LARGE_CHEST_SIZE = 54;
    protected final class_1799 stack;
    protected final class_1263 inventory;
    protected int stackIndex = -1;
    protected boolean outOfSlot = false;
    private final int slots;

    public BasicInventoryGui(class_3222 player, class_1799 stack, class_1263 inventory) {
        super(BasicInventoryGui.getHandler(inventory.method_5439()), player, false);
        this.stack = stack;
        this.inventory = inventory;
        this.slots = inventory.method_5439();
        class_5250 title = class_2561.method_43471((String)"item.serverbackpacks.gui_backpack");
        if (this.stack != null) {
            stack.method_57379(BackpackDataComponentTypes.IS_OPENED, (Object)true);
            title = title.method_27661().method_27693(" (").method_10852(stack.method_7964()).method_27693(")");
        }
        if (ServerBackpacks.isBedrock(player) && this.slots != 27 && this.slots != 54) {
            title = title.method_27661().method_27693(BEDROCK_ROW_MARKER + this.slots / 9);
        }
        this.setTitle(class_2561.method_54155((Message)title));
        this.fillChest();
        this.open();
        this.afterOpened();
    }

    public int slots() {
        return this.slots;
    }

    public void slotUpdate() {
    }

    public void afterOpened() {
        if (this.stack != null) {
            this.lockSlot();
        }
        this.getPlayer().field_7512.method_7596(new class_1712(){

            public void method_7635(class_1703 handler, int slotId, class_1799 stackSlot) {
                BasicInventoryGui.this.slotUpdate();
                if (BasicInventoryGui.this.stackIndex != -1 && BasicInventoryGui.this.stack != null && handler.method_7611(BasicInventoryGui.this.stackIndex).method_7677() != BasicInventoryGui.this.stack) {
                    BasicInventoryGui.this.outOfSlot = true;
                }
            }

            public void method_7633(class_1703 handler, int property, int value) {
            }
        });
    }

    public void lockSlot() {
        block0: for (int j = 0; j <= 3; ++j) {
            for (int k = 0; k < 9; ++k) {
                int index;
                int n = index = j == 0 ? k + (36 + this.slots) - 9 : this.slots + (k + j * 9) - 9;
                if (!class_1799.method_31577((class_1799)this.screenHandler.method_7611(index).method_7677(), (class_1799)this.stack)) continue;
                this.stackIndex = index;
                continue block0;
            }
        }
    }

    public void onTick() {
        if (this.outOfSlot) {
            this.close();
        }
    }

    public static class_3917<?> getHandler(int slots) {
        return switch (slots / 9) {
            case 1 -> class_3917.field_18664;
            case 2 -> class_3917.field_18665;
            case 3 -> class_3917.field_17326;
            case 4 -> class_3917.field_18666;
            case 5 -> class_3917.field_18667;
            default -> class_3917.field_17327;
        };
    }

    public void fillChest() {
        for (int i = 0; i < this.slots; ++i) {
            this.setSlotRedirect(i, new NonBackpackSlot(this.inventory, i, i, 0));
        }
    }
}

