/*
 * Decompiled with CFR 0.152.
 */
package com.rouesvm.servback.compat.geyser;

import com.rouesvm.servback.utils.bedrock.BedrockItem;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1792;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import org.geysermc.event.subscribe.Subscribe;
import org.geysermc.geyser.api.GeyserApi;
import org.geysermc.geyser.api.event.EventRegistrar;
import org.geysermc.geyser.api.event.lifecycle.GeyserDefineCustomItemsEvent;
import org.geysermc.geyser.api.event.lifecycle.GeyserLoadResourcePacksEvent;
import org.geysermc.geyser.api.item.custom.NonVanillaCustomItemData;

public class BackpackGeyser
implements EventRegistrar {
    public static Path PACKS_FOLDER;
    public static Path GEYSER_PACK;
    static GeyserApi geyser;

    public static void initialize() {
        BackpackGeyser.loadResourcePack();
        ServerLifecycleEvents.SERVER_STARTING.register(minecraftServer -> {
            geyser = GeyserApi.api();
            BackpackGeyser registrar = new BackpackGeyser();
            geyser.eventBus().register((Object)registrar, (Object)registrar);
        });
    }

    public static void loadResourcePack() {
        PACKS_FOLDER = FabricLoader.getInstance().getConfigDir().resolve("serverbackpacks/");
        GEYSER_PACK = PACKS_FOLDER.resolve("backpack.zip");
        try {
            if (!GEYSER_PACK.toFile().exists()) {
                Files.createDirectories(PACKS_FOLDER, new FileAttribute[0]);
                Path file = (Path)FabricLoader.getInstance().getModContainer("serverbackpacks").flatMap(modContainer -> modContainer.findPath("bedrock/backpack.zip")).get();
                Files.copy(file, GEYSER_PACK, new CopyOption[0]);
                GEYSER_PACK = PACKS_FOLDER.resolve("backpack.zip");
            }
        }
        catch (Exception e) {
            throw new RuntimeException("PACK doesn't exist!");
        }
    }

    @Subscribe
    public void onDefineResource(GeyserLoadResourcePacksEvent event) {
        if (GEYSER_PACK.toFile().exists()) {
            event.resourcePacks().add(GEYSER_PACK);
        }
    }

    @Subscribe
    public void onGeyserDefineCustomItemsEvent(GeyserDefineCustomItemsEvent event) {
        for (Map.Entry entry : class_7923.field_41178.method_29722()) {
            class_1792 item = (class_1792)entry.getValue();
            if (!(item instanceof BedrockItem)) continue;
            int id = class_7923.field_41178.method_10206((Object)item);
            class_2960 identifier = ((class_5321)entry.getKey()).method_29177();
            NonVanillaCustomItemData customItemData = NonVanillaCustomItemData.builder().displayName(class_2561.method_43471((String)item.method_7876()).getString()).name(class_2561.method_43471((String)item.method_7876()).getString()).javaId(id).stackSize(1).identifier(identifier.toString()).translationString(item.method_7876()).allowOffhand(true).displayHandheld(true).icon(identifier.toString()).creativeCategory(3).build();
            event.register(customItemData);
        }
    }

    public static boolean isPlayerOnBedrock(class_3222 player) {
        if (geyser == null || player == null) {
            return false;
        }
        return geyser.isBedrockPlayer(player.method_5667());
    }
}

