/*
 * Decompiled with CFR 0.152.
 */
package com.rouesvm.servback.items;

import com.rouesvm.servback.Main;
import com.rouesvm.servback.items.GuiItem;
import com.rouesvm.servback.registry.BackpackItemRegistry;
import com.rouesvm.servback.registry.BackpacksDataComponentTypes;
import com.rouesvm.servback.ui.BackpackGui;
import com.rouesvm.servback.ui.inventory.BackpackInventory;
import com.rouesvm.servback.utils.BackpackManager;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5455;
import net.minecraft.class_5632;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_9279;
import net.minecraft.class_9288;
import net.minecraft.class_9334;
import xyz.nucleoid.packettweaker.PacketContext;

public class ContainerItem
extends GuiItem {
    private final int slots;

    public ContainerItem(String name, int slots) {
        super(name);
        this.slots = slots;
    }

    public boolean method_31568() {
        return false;
    }

    public Optional<class_5632> method_32346(class_1799 stack) {
        return super.method_32346(stack);
    }

    public void modifyClientTooltip(List<class_2561> tooltip, class_1799 polymerStack, PacketContext context) {
        BackpackInventory itemList = this.getItemList(polymerStack);
        if (itemList == null) {
            return;
        }
        if (itemList.getHeldStacks().isEmpty()) {
            return;
        }
        int capacityMaxShow = 0;
        int capacityAmount = 0;
        for (class_1799 itemStack : itemList.getHeldStacks()) {
            if (itemStack.method_7960()) continue;
            ++capacityAmount;
            if (capacityMaxShow > 4) continue;
            ++capacityMaxShow;
            tooltip.add((class_2561)class_2561.method_43469((String)"item.container.item_count", (Object[])new Object[]{itemStack.method_7964(), itemStack.method_7947()}).method_27692(class_124.field_1065));
        }
        if (capacityAmount - capacityMaxShow > 0) {
            tooltip.add((class_2561)class_2561.method_43469((String)"item.container.more_items", (Object[])new Object[]{capacityAmount - capacityMaxShow}).method_27692(class_124.field_1056).method_27692(class_124.field_1065));
        }
    }

    @Override
    public void openGui(class_3222 player, class_1799 stack) {
        BackpackManager.createNewUUID(stack);
        this.checkEnchantments(stack, player);
        player.method_17356(class_3417.field_34376, class_3419.field_15248, 0.8f, 0.8f + player.method_37908().method_8409().method_43057() * 0.4f);
        stack.method_57379(BackpacksDataComponentTypes.BOOLEAN_TYPE, (Object)false);
        new BackpackGui(player, stack, this.getExtendedSlots(stack) + this.slots);
    }

    public class_2371<class_1799> getComponentItemList(class_1799 stack) {
        class_2371 list = class_2371.method_10213((int)(this.slots + this.getExtendedSlots(stack)), (Object)class_1799.field_8037);
        ((class_9288)stack.method_58695(class_9334.field_49622, (Object)class_9288.field_49334)).method_57492(list);
        return list;
    }

    private BackpackInventory getItemList(class_1799 stack) {
        if (stack.method_58694(BackpacksDataComponentTypes.UUID_TYPE) == null) {
            return null;
        }
        UUID uuid = BackpackManager.getStackUUID(stack);
        return BackpackManager.getInventory(uuid, this.getExtendedSlots(stack) + this.slots);
    }

    private int getExtendedSlots(class_1799 stack) {
        class_9279 component = (class_9279)stack.method_58695(class_9334.field_49628, (Object)class_9279.field_49302);
        class_2487 compound = component.method_57461();
        if (compound.method_10545("level")) {
            return 9 * compound.method_68083("level", 0);
        }
        return 0;
    }

    private void checkEnchantments(class_1799 stack, class_3222 player) {
        BackpackInventory inventory = this.getItemList(stack);
        if (inventory == null) {
            return;
        }
        class_5455 registryManager = player.method_37908().method_30349();
        class_6880.class_6883 capacity = ((class_2378)registryManager.method_46759(class_7924.field_41265).get()).method_46747(Main.CAPACITY);
        int level = stack.method_58657().method_57536((class_6880)capacity);
        int currentSize = 9 * level;
        class_2487 compound = new class_2487();
        compound.method_10569("level", level);
        stack.method_57379(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)compound));
        UUID uuid = BackpackManager.getStackUUID(stack);
        if (currentSize > 0) {
            int totalSlots = currentSize + this.slots;
            if (inventory.method_5439() != totalSlots) {
                BackpackManager.resizeInventory(uuid, inventory, totalSlots);
            }
            return;
        }
        if (inventory.method_5439() > this.slots) {
            this.dropExcessItems(inventory, this.slots, player);
        }
        BackpackManager.resizeInventory(uuid, inventory, this.slots);
    }

    private void dropExcessItems(BackpackInventory inventory, int maxSlots, class_3222 player) {
        for (int i = inventory.method_5439(); i > maxSlots; --i) {
            class_1799 excessItem = (class_1799)inventory.getHeldStacks().get(i - 1);
            player.method_7328(excessItem, true);
        }
        player.method_17356(class_3417.field_34375, class_3419.field_15248, 0.8f, 0.8f + player.method_37908().method_8409().method_43057() * 0.4f);
    }

    public static Map<String, class_1792> getBackpackMap() {
        return Map.ofEntries(Map.entry("WHITE_1", BackpackItemRegistry.WHITE_SMALL_BACKPACK), Map.entry("WHITE_2", BackpackItemRegistry.WHITE_MEDIUM_BACKPACK), Map.entry("WHITE_3", BackpackItemRegistry.WHITE_LARGE_BACKPACK), Map.entry("ORANGE_1", BackpackItemRegistry.ORANGE_SMALL_BACKPACK), Map.entry("ORANGE_2", BackpackItemRegistry.ORANGE_MEDIUM_BACKPACK), Map.entry("ORANGE_3", BackpackItemRegistry.ORANGE_LARGE_BACKPACK), Map.entry("MAGENTA_1", BackpackItemRegistry.MAGENTA_SMALL_BACKPACK), Map.entry("MAGENTA_2", BackpackItemRegistry.MAGENTA_MEDIUM_BACKPACK), Map.entry("MAGENTA_3", BackpackItemRegistry.MAGENTA_LARGE_BACKPACK), Map.entry("LIGHT_BLUE_1", BackpackItemRegistry.LIGHT_BLUE_SMALL_BACKPACK), Map.entry("LIGHT_BLUE_2", BackpackItemRegistry.LIGHT_BLUE_MEDIUM_BACKPACK), Map.entry("LIGHT_BLUE_3", BackpackItemRegistry.LIGHT_BLUE_LARGE_BACKPACK), Map.entry("YELLOW_1", BackpackItemRegistry.YELLOW_SMALL_BACKPACK), Map.entry("YELLOW_2", BackpackItemRegistry.YELLOW_MEDIUM_BACKPACK), Map.entry("YELLOW_3", BackpackItemRegistry.YELLOW_LARGE_BACKPACK), Map.entry("LIME_1", BackpackItemRegistry.LIME_SMALL_BACKPACK), Map.entry("LIME_2", BackpackItemRegistry.LIME_MEDIUM_BACKPACK), Map.entry("LIME_3", BackpackItemRegistry.LIME_LARGE_BACKPACK), Map.entry("PINK_1", BackpackItemRegistry.PINK_SMALL_BACKPACK), Map.entry("PINK_2", BackpackItemRegistry.PINK_MEDIUM_BACKPACK), Map.entry("PINK_3", BackpackItemRegistry.PINK_LARGE_BACKPACK), Map.entry("GRAY_1", BackpackItemRegistry.LIGHT_GRAY_SMALL_BACKPACK), Map.entry("GRAY_2", BackpackItemRegistry.LIGHT_GRAY_MEDIUM_BACKPACK), Map.entry("GRAY_3", BackpackItemRegistry.LIGHT_GRAY_LARGE_BACKPACK), Map.entry("LIGHT_GRAY_1", BackpackItemRegistry.LIGHT_GRAY_SMALL_BACKPACK), Map.entry("LIGHT_GRAY_2", BackpackItemRegistry.LIGHT_GRAY_MEDIUM_BACKPACK), Map.entry("LIGHT_GRAY_3", BackpackItemRegistry.LIGHT_GRAY_LARGE_BACKPACK), Map.entry("CYAN_1", BackpackItemRegistry.CYAN_SMALL_BACKPACK), Map.entry("CYAN_2", BackpackItemRegistry.CYAN_MEDIUM_BACKPACK), Map.entry("CYAN_3", BackpackItemRegistry.CYAN_LARGE_BACKPACK), Map.entry("BLUE_1", BackpackItemRegistry.BLUE_SMALL_BACKPACK), Map.entry("BLUE_2", BackpackItemRegistry.BLUE_MEDIUM_BACKPACK), Map.entry("BLUE_3", BackpackItemRegistry.BLUE_LARGE_BACKPACK), Map.entry("GREEN_1", BackpackItemRegistry.GREEN_SMALL_BACKPACK), Map.entry("GREEN_2", BackpackItemRegistry.GREEN_MEDIUM_BACKPACK), Map.entry("GREEN_3", BackpackItemRegistry.GREEN_LARGE_BACKPACK), Map.entry("RED_1", BackpackItemRegistry.RED_SMALL_BACKPACK), Map.entry("RED_2", BackpackItemRegistry.RED_MEDIUM_BACKPACK), Map.entry("RED_3", BackpackItemRegistry.RED_LARGE_BACKPACK), Map.entry("BLACK_1", BackpackItemRegistry.BLACK_SMALL_BACKPACK), Map.entry("BLACK_2", BackpackItemRegistry.BLACK_MEDIUM_BACKPACK), Map.entry("BLACK_3", BackpackItemRegistry.BLACK_LARGE_BACKPACK), Map.entry("PURPLE_1", BackpackItemRegistry.PURPLE_SMALL_BACKPACK), Map.entry("PURPLE_2", BackpackItemRegistry.PURPLE_MEDIUM_BACKPACK), Map.entry("PURPLE_3", BackpackItemRegistry.PURPLE_LARGE_BACKPACK));
    }

    public int getSize() {
        return this.slots / 9;
    }

    public static class_1792 getColoredBackpack(class_1767 color, int size) {
        class_1792 item = color != null ? ContainerItem.getBackpackMap().getOrDefault(color.name() + "_" + size, ContainerItem.getDefaultBackpack(size)) : ContainerItem.getDefaultBackpack(size);
        return item;
    }

    public static class_1792 getDefaultBackpack(int size) {
        return switch (size) {
            case 1 -> BackpackItemRegistry.SMALL_BACKPACK;
            case 2 -> BackpackItemRegistry.MEDIUM_BACKPACK;
            default -> BackpackItemRegistry.LARGE_BACKPACK;
        };
    }
}

