/*
 * Decompiled with CFR 0.152.
 */
package com.rouesvm.servback.state;

import com.rouesvm.servback.ui.inventory.BackpackInventory;
import com.rouesvm.servback.utils.BackpackInstance;
import com.rouesvm.servback.utils.BackpackManager;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import net.minecraft.class_1262;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import net.minecraft.class_2520;
import net.minecraft.class_4844;
import net.minecraft.class_5218;
import net.minecraft.class_7225;
import net.minecraft.server.MinecraftServer;

public class BackpackDataFixer {
    public static void onWorldLoading(MinecraftServer server) {
        Path path = server.method_27050(class_5218.field_24188).resolve(Path.of("data/serverbackpacks.dat", new String[0]));
        if (!path.toFile().exists()) {
            return;
        }
        class_2487 oldData = null;
        try (DataInputStream dataInputStream2 = new DataInputStream(new GZIPInputStream(new FileInputStream(path.toFile())));){
            oldData = class_2507.method_10627((DataInput)dataInputStream2);
        }
        catch (Exception dataInputStream2) {
            // empty catch block
        }
        if (oldData != null) {
            Set<BackpackInstance> instances = BackpackDataFixer.convertToV2Format(oldData, (class_7225.class_7874)server.method_30611());
            instances.forEach(backpackInstance -> BackpackManager.getManager().storedInstances.put(backpackInstance.getUuid(), (BackpackInstance)backpackInstance));
            BackpackManager.getManager().save(server);
            try {
                Files.delete(path);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static BackpackInstance load(class_2487 compound, class_7225.class_7874 registryLookup) {
        return new BackpackInstance(class_4844.method_26276((int[])((int[])compound.method_10561("uuid").get())), BackpackDataFixer.loadInventory((class_2487)compound.method_10562("contents").get(), registryLookup));
    }

    public static Set<BackpackInstance> convertToV2Format(class_2487 nbt, class_7225.class_7874 registryLookup) {
        HashSet<BackpackInstance> instances = new HashSet<BackpackInstance>();
        class_2520 data = nbt.method_10580("data");
        if (data instanceof class_2487) {
            class_2487 compound = (class_2487)data;
            Optional list = compound.method_10554("backpackContents");
            list.ifPresent(nbtElements -> nbtElements.forEach(element -> instances.add(BackpackDataFixer.load((class_2487)element, registryLookup))));
            Optional globalNbt = compound.method_10562("global");
            if (globalNbt.isPresent()) {
                BackpackInventory globalInventory = BackpackDataFixer.loadInventory((class_2487)globalNbt.get(), registryLookup);
                BackpackManager.getManager().setGlobalInventory(globalInventory.getHeldStacks());
            }
        }
        return instances;
    }

    public static BackpackInventory loadInventory(class_2487 nbtCompound, class_7225.class_7874 registryLookup) {
        class_2371 itemStacks = class_2371.method_10213((int)54, (Object)class_1799.field_8037);
        class_1262.method_5429((class_2487)nbtCompound, (class_2371)itemStacks, (class_7225.class_7874)registryLookup);
        return new BackpackInventory((class_2371<class_1799>)itemStacks);
    }
}

