/*
 * Decompiled with CFR 0.152.
 */
package com.rouesvm.servback.state;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.rouesvm.servback.state.codecs.BackpackData;
import com.rouesvm.servback.state.codecs.InventoryData;
import com.rouesvm.servback.state.codecs.SlotData;
import com.rouesvm.servback.ui.inventory.BackpackInventory;
import com.rouesvm.servback.utils.BackpackInstance;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_10741;
import net.minecraft.class_18;
import net.minecraft.class_26;
import net.minecraft.server.MinecraftServer;

public class BackpackState
extends class_18 {
    public Set<BackpackData> storedInventories = new HashSet<BackpackData>();
    private static final Codec<BackpackState> SAVE_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BackpackData.CODEC.listOf().fieldOf("backpackContents").forGetter(BackpackState::getStoredInventories)).apply((Applicative)instance, BackpackState::new));
    private static final class_10741<BackpackState> type = new class_10741("serverbackpacks-v2", BackpackState::new, SAVE_CODEC, null);

    public BackpackState(List<BackpackData> data) {
        this.storedInventories.addAll(data);
    }

    public BackpackState() {
        this(Collections.emptyList());
    }

    public static BackpackState getServerState(MinecraftServer server) {
        class_26 persistentStateManager = server.method_30002().method_17983();
        BackpackState state = (BackpackState)persistentStateManager.method_17924(type);
        state.method_80();
        return state;
    }

    public List<BackpackData> getStoredInventories() {
        return new ArrayList<BackpackData>(this.storedInventories);
    }

    public Set<BackpackInstance> getBackpackInstances() {
        return this.storedInventories.stream().map(data -> new BackpackInstance(data.getUuid(), new BackpackInventory(InventoryData.getHeldStacks(data.getInventoryData().getItemStacks())))).collect(Collectors.toSet());
    }

    public void setStoredInventories(Set<BackpackInstance> backpackInstances) {
        this.storedInventories.clear();
        for (BackpackInstance instance : backpackInstances) {
            BackpackData data = new BackpackData(instance.getUuid(), new InventoryData(SlotData.writeToCodec(instance.getHeldInventory())));
            this.storedInventories.add(data);
        }
        this.method_80();
    }
}

