/*
 * Decompiled with CFR 0.152.
 */
package com.rouesvm.servback.ui;

import com.rouesvm.servback.items.ContainerItem;
import com.rouesvm.servback.registry.BackpacksDataComponentTypes;
import com.rouesvm.servback.ui.inventory.BackpackInventory;
import com.rouesvm.servback.ui.slots.BackpackSlot;
import com.rouesvm.servback.utils.BackpackInstance;
import com.rouesvm.servback.utils.BackpackManager;
import eu.pb4.sgui.api.gui.SimpleGui;
import java.util.UUID;
import net.minecraft.class_1703;
import net.minecraft.class_1712;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3917;
import net.minecraft.class_9334;

public class BackpackGui
extends SimpleGui {
    protected final UUID uuid;
    protected final class_1799 stack;
    protected final BackpackInstance backpackInstance;
    protected int stackIndex;
    protected boolean outOfSlot = false;

    public BackpackGui(class_3222 player, class_1799 stack, int slots) {
        super(BackpackGui.getHandler(slots), player, false);
        stack.method_57379(BackpacksDataComponentTypes.BOOLEAN_TYPE, (Object)true);
        this.uuid = BackpackManager.getStackUUID(stack);
        this.stack = stack;
        this.backpackInstance = BackpackManager.getInstance(this.uuid, slots);
        this.backpackInstance.setLastAccessed();
        this.convertComponentToBackpackData();
        this.setTitle((class_2561)class_2561.method_43471((String)"item.serverbackpacks.gui_backpack"));
        this.fillChest();
        this.open();
        this.afterOpened();
    }

    private void convertComponentToBackpackData() {
        class_1792 class_17922;
        BackpackInventory inventory = this.backpackInstance.getInventory();
        if (inventory.method_5442() && this.stack.method_58694(class_9334.field_49622) != null && (class_17922 = this.stack.method_7909()) instanceof ContainerItem) {
            ContainerItem item = (ContainerItem)class_17922;
            class_2371<class_1799> itemStacks = item.getComponentItemList(this.stack);
            if (inventory.insertItems(itemStacks)) {
                this.backpackInstance.setInventory(inventory);
                BackpackManager.getManager().saveBackpack(this.backpackInstance);
            }
            this.stack.method_57379(class_9334.field_49622, null);
        }
    }

    public void afterOpened() {
        int slots = this.backpackInstance.getInventory().method_5439();
        for (int k = 0; k < 9; ++k) {
            int index = k + (36 + slots) - 9;
            if (!this.screenHandler.method_7611(index).method_7677().equals(this.stack)) continue;
            this.stackIndex = index;
            break;
        }
        this.getPlayer().field_7512.method_7596(new class_1712(){

            public void method_7635(class_1703 handler, int slotId, class_1799 stackSlot) {
                if (handler.method_7611(BackpackGui.this.stackIndex).method_7677() != BackpackGui.this.stack) {
                    BackpackGui.this.outOfSlot = true;
                }
                BackpackManager.getManager().saveBackpack(BackpackGui.this.backpackInstance);
            }

            public void method_7633(class_1703 handler, int property, int value) {
            }
        });
    }

    public void onClose() {
        BackpackManager.getManager().save(this.getPlayer().method_5682());
        this.stack.method_57379(BackpacksDataComponentTypes.BOOLEAN_TYPE, (Object)false);
    }

    public void onTick() {
        if (this.outOfSlot) {
            this.close();
        }
    }

    public static class_3917<?> getHandler(int slots) {
        return switch (slots / 9) {
            case 1 -> class_3917.field_18664;
            case 2 -> class_3917.field_18665;
            case 3 -> class_3917.field_17326;
            case 4 -> class_3917.field_18666;
            case 5 -> class_3917.field_18667;
            default -> class_3917.field_17327;
        };
    }

    public void fillChest() {
        for (int j = 0; j < this.backpackInstance.getInventory().method_5439(); ++j) {
            this.setSlotRedirect(j, new BackpackSlot(this.backpackInstance.getInventory(), j, j, 0));
        }
    }
}

