/*
 * Decompiled with CFR 0.152.
 */
package com.rouesvm.servback.ui.inventory;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1265;
import net.minecraft.class_1657;
import net.minecraft.class_1737;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2371;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_7225;
import net.minecraft.class_9875;
import org.jetbrains.annotations.Nullable;

public class BaseInventory
implements class_1263,
class_1737 {
    private final int size;
    public class_2371<class_1799> heldStacks;
    @Nullable
    private List<class_1265> listeners;

    public BaseInventory(int size) {
        this.size = size;
        this.heldStacks = class_2371.method_10213((int)size, (Object)class_1799.field_8037);
    }

    public BaseInventory(class_1799 ... items) {
        this.size = items.length;
        this.heldStacks = class_2371.method_10212((Object)class_1799.field_8037, (Object[])items);
    }

    public void addListener(class_1265 listener) {
        if (this.listeners == null) {
            this.listeners = Lists.newArrayList();
        }
        this.listeners.add(listener);
    }

    public void removeListener(class_1265 listener) {
        if (this.listeners != null) {
            this.listeners.remove(listener);
        }
    }

    public class_1799 method_5438(int slot) {
        return slot >= 0 && slot < this.heldStacks.size() ? (class_1799)this.heldStacks.get(slot) : class_1799.field_8037;
    }

    public List<class_1799> clearToList() {
        List<class_1799> list = this.heldStacks.stream().filter(stack -> !stack.method_7960()).collect(Collectors.toList());
        this.method_5448();
        return list;
    }

    public class_1799 method_5434(int slot, int amount) {
        class_1799 itemStack = class_1262.method_5430(this.heldStacks, (int)slot, (int)amount);
        if (!itemStack.method_7960()) {
            this.method_5431();
        }
        return itemStack;
    }

    public class_1799 removeItem(class_1792 item, int count) {
        class_1799 itemStack = new class_1799((class_1935)item, 0);
        for (int i = this.size - 1; i >= 0; --i) {
            class_1799 itemStack2 = this.method_5438(i);
            if (!itemStack2.method_7909().equals(item)) continue;
            int j = count - itemStack.method_7947();
            class_1799 itemStack3 = itemStack2.method_7971(j);
            itemStack.method_7933(itemStack3.method_7947());
            if (itemStack.method_7947() == count) break;
        }
        if (!itemStack.method_7960()) {
            this.method_5431();
        }
        return itemStack;
    }

    public class_1799 addStack(class_1799 stack) {
        if (stack.method_7960()) {
            return class_1799.field_8037;
        }
        class_1799 itemStack = stack.method_7972();
        this.addToExistingSlot(itemStack);
        if (itemStack.method_7960()) {
            return class_1799.field_8037;
        }
        this.addToNewSlot(itemStack);
        return itemStack.method_7960() ? class_1799.field_8037 : itemStack;
    }

    public boolean canInsert(class_1799 stack) {
        boolean bl = false;
        for (class_1799 itemStack : this.heldStacks) {
            if (!itemStack.method_7960() && (!class_1799.method_31577((class_1799)itemStack, (class_1799)stack) || itemStack.method_7947() >= itemStack.method_7914())) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public class_1799 method_5441(int slot) {
        class_1799 itemStack = (class_1799)this.heldStacks.get(slot);
        if (itemStack.method_7960()) {
            return class_1799.field_8037;
        }
        this.heldStacks.set(slot, (Object)class_1799.field_8037);
        return itemStack;
    }

    public void method_5447(int slot, class_1799 stack) {
        this.heldStacks.set(slot, (Object)stack);
        stack.method_58408(this.method_58350(stack));
        this.method_5431();
    }

    public int method_5439() {
        return this.size;
    }

    public boolean method_5442() {
        for (class_1799 itemStack : this.heldStacks) {
            if (itemStack.method_7960()) continue;
            return false;
        }
        return true;
    }

    public void method_5431() {
        if (this.listeners != null) {
            for (class_1265 inventoryChangedListener : this.listeners) {
                inventoryChangedListener.method_5453((class_1263)this);
            }
        }
    }

    public boolean method_5443(class_1657 player) {
        return true;
    }

    public void method_5448() {
        this.heldStacks.clear();
        this.method_5431();
    }

    public void method_7683(class_9875 finder) {
        for (class_1799 itemStack : this.heldStacks) {
            finder.method_61541(itemStack);
        }
    }

    public String toString() {
        return this.heldStacks.stream().filter(stack -> !stack.method_7960()).toList().toString();
    }

    private void addToNewSlot(class_1799 stack) {
        for (int i = 0; i < this.size; ++i) {
            class_1799 itemStack = this.method_5438(i);
            if (!itemStack.method_7960()) continue;
            this.method_5447(i, stack.method_51164());
            return;
        }
    }

    private void addToExistingSlot(class_1799 stack) {
        for (int i = 0; i < this.size; ++i) {
            class_1799 itemStack = this.method_5438(i);
            if (!class_1799.method_31577((class_1799)itemStack, (class_1799)stack)) continue;
            this.transfer(stack, itemStack);
            if (!stack.method_7960()) continue;
            return;
        }
    }

    private void transfer(class_1799 source, class_1799 target) {
        int i = this.method_58350(target);
        int j = Math.min(source.method_7947(), i - target.method_7947());
        if (j > 0) {
            target.method_7933(j);
            source.method_7934(j);
            this.method_5431();
        }
    }

    public void readNbtList(class_2499 list, class_7225.class_7874 registries) {
        this.method_5448();
        for (int i = 0; i < list.size(); ++i) {
            class_1799.method_57360((class_7225.class_7874)registries, (class_2520)list.method_68582(i)).ifPresent(this::addStack);
        }
    }

    public class_2499 toNbtList(class_7225.class_7874 registries) {
        class_2499 nbtList = new class_2499();
        for (int i = 0; i < this.method_5439(); ++i) {
            class_1799 itemStack = this.method_5438(i);
            if (itemStack.method_7960()) continue;
            nbtList.add((Object)itemStack.method_57358(registries));
        }
        return nbtList;
    }

    public class_2371<class_1799> getHeldStacks() {
        return this.heldStacks;
    }
}

