/*
 * Decompiled with CFR 0.152.
 */
package com.rouesvm.servback.utils;

import com.rouesvm.servback.registry.BackpacksDataComponentTypes;
import com.rouesvm.servback.state.BackpackDataFixer;
import com.rouesvm.servback.state.BackpackState;
import com.rouesvm.servback.state.GlobalBackpackState;
import com.rouesvm.servback.ui.inventory.BackpackInventory;
import com.rouesvm.servback.utils.BackpackInstance;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.server.MinecraftServer;

public class BackpackManager {
    private static BackpackManager manager = null;
    public BackpackInventory globalInventory;
    public Map<UUID, BackpackInstance> storedInstances = new HashMap<UUID, BackpackInstance>();

    private BackpackManager() {
        this.globalInventory = new BackpackInventory(27);
    }

    public static BackpackManager getManager() {
        return manager;
    }

    public static void setup(MinecraftServer server) {
        manager = new BackpackManager();
        manager.load(server);
        BackpackDataFixer.onWorldLoading(server);
    }

    public static void destroy(MinecraftServer server) {
        if (manager != null) {
            manager.save(server);
            manager = null;
        }
    }

    public static UUID getStackUUID(class_1799 stack) {
        String uuidString = (String)stack.method_58694(BackpacksDataComponentTypes.UUID_TYPE);
        if (uuidString == null) {
            uuidString = String.valueOf(BackpackManager.createNewUUID(stack));
        }
        return UUID.fromString(uuidString);
    }

    public static UUID createNewUUID(class_1799 stack) {
        String uuidString = (String)stack.method_58694(BackpacksDataComponentTypes.UUID_TYPE);
        if (uuidString == null) {
            UUID uuid = BackpackManager.generateUniqueUUID();
            stack.method_57379(BackpacksDataComponentTypes.UUID_TYPE, (Object)uuid.toString());
            return uuid;
        }
        return UUID.fromString(uuidString);
    }

    private static UUID generateUniqueUUID() {
        UUID uuid = UUID.randomUUID();
        if (manager != null) {
            for (int attempts = 0; manager.hasBackpack(uuid) && attempts < 100; ++attempts) {
                uuid = UUID.randomUUID();
            }
        }
        return uuid;
    }

    public static BackpackInstance getInstance(UUID uuid, int slots) {
        BackpackManager manager = BackpackManager.getManager();
        if (manager.hasBackpack(uuid)) {
            BackpackInstance backpack = manager.storedInstances.get(uuid);
            BackpackInventory inventory = backpack.getInventory();
            if (inventory.method_5439() != slots) {
                backpack.setInventory(BackpackManager.resizeInventory(inventory, slots));
                manager.saveBackpack(backpack);
            }
            return backpack;
        }
        return new BackpackInstance(uuid, new BackpackInventory(slots));
    }

    public static BackpackInventory getInventory(UUID uuid, int slots) {
        return BackpackManager.getInstance(uuid, slots).getInventory();
    }

    public static BackpackInventory resizeInventory(BackpackInventory inventory, int newSize) {
        BackpackInventory newInventory = new BackpackInventory(newSize);
        inventory.copyTo(newInventory);
        return newInventory;
    }

    public static void resizeInventory(UUID uuid, BackpackInventory inventory, int newSize) {
        manager.saveBackpack(uuid, BackpackManager.resizeInventory(inventory, newSize));
    }

    public void saveBackpack(BackpackInstance instance) {
        if (instance.getUuid() != null && instance.getInventory() != null) {
            this.storedInstances.put(instance.getUuid(), instance);
        }
    }

    public void saveBackpack(UUID uuid, BackpackInventory backpackInventory) {
        this.saveBackpack(new BackpackInstance(uuid, backpackInventory));
    }

    public void load(Set<BackpackInstance> instances) {
        instances.forEach(this::saveBackpack);
    }

    public void load(MinecraftServer server) {
        BackpackState backpackState = BackpackState.getServerState(server);
        this.load(backpackState.getBackpackInstances());
        GlobalBackpackState globalBackpackState = GlobalBackpackState.getServerState(server);
        this.globalInventory = globalBackpackState.globalInventory;
    }

    public Set<BackpackInstance> save() {
        return new HashSet<BackpackInstance>(this.storedInstances.values());
    }

    public void save(MinecraftServer server) {
        BackpackState backpackState = BackpackState.getServerState(server);
        backpackState.setStoredInventories(this.save());
        GlobalBackpackState globalBackpackState = GlobalBackpackState.getServerState(server);
        globalBackpackState.globalInventory = this.globalInventory;
    }

    public void setGlobalInventory(class_2371<class_1799> stacks) {
        this.globalInventory.setInventoryDirectly(stacks);
    }

    public boolean hasBackpack(UUID uuid) {
        return uuid != null && this.storedInstances.containsKey(uuid);
    }
}

