/*
 * Decompiled with CFR 0.152.
 */
package com.rouesvm.servback.compat.geyser;

import com.rouesvm.servback.compat.geyser.bedrock.BedrockBlock;
import com.rouesvm.servback.content.block.impl.BackpackBlock;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1767;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_2680;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3542;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import org.geysermc.geyser.api.block.custom.CustomBlockData;
import org.geysermc.geyser.api.block.custom.CustomBlockPermutation;
import org.geysermc.geyser.api.block.custom.CustomBlockState;
import org.geysermc.geyser.api.block.custom.NonVanillaCustomBlockData;
import org.geysermc.geyser.api.block.custom.component.BoxComponent;
import org.geysermc.geyser.api.block.custom.component.CustomBlockComponents;
import org.geysermc.geyser.api.block.custom.component.GeometryComponent;
import org.geysermc.geyser.api.block.custom.component.MaterialInstance;
import org.geysermc.geyser.api.block.custom.component.TransformationComponent;
import org.geysermc.geyser.api.block.custom.nonvanilla.JavaBlockState;
import org.geysermc.geyser.api.block.custom.nonvanilla.JavaBoundingBox;
import org.geysermc.geyser.api.event.lifecycle.GeyserDefineCustomBlocksEvent;

public class BackpackGeyserBlock {
    public static final List<String> dye_colors = Arrays.stream(class_1767.values()).map(class_1767::method_15434).toList();
    public static final List<String> facing = class_2383.field_11177.method_11898().stream().map(class_2350::method_15434).toList();
    public static final List<Integer> slots = new ArrayList<Integer>();
    public static final String STATE_CONDITION = "query.block_property('%s') == %s";

    public static void onGeyserDefineCustomBlocksEvent(GeyserDefineCustomBlocksEvent event) {
        class_7923.field_41175.method_29722().stream().filter(entry -> entry.getValue() instanceof BedrockBlock).forEach(entry -> {
            class_2960 location = ((class_5321)entry.getKey()).method_29177();
            class_2248 block = (class_2248)entry.getValue();
            NonVanillaCustomBlockData customBlockData = BackpackGeyserBlock.createHorizontalBlock(block, location).permutations(BackpackGeyserBlock.createHorizontalBlockPermutations()).build();
            if (block instanceof BackpackBlock) {
                customBlockData = BackpackGeyserBlock.registerBackpackBlock(block, location);
            }
            event.register((CustomBlockData)customBlockData);
            BackpackGeyserBlock.registerForBlockState(event, customBlockData, block, location);
        });
    }

    public static void registerForBlockState(GeyserDefineCustomBlocksEvent event, NonVanillaCustomBlockData customBlockData, class_2248 block, class_2960 location) {
        int blockId = class_7923.field_41175.method_10206((Object)block);
        for (class_2680 state : block.method_9595().method_11662()) {
            CustomBlockState.Builder stateBuilder = BackpackGeyserBlock.blockStateBuilder((CustomBlockData)customBlockData, state);
            JavaBlockState javaBlockState = JavaBlockState.builder().identifier(location.toString()).blockHardness(block.method_36555()).canBreakWithHand(true).collision(new JavaBoundingBox[]{new JavaBoundingBox(0.0, 0.0, 0.0, 1.0, 1.0, 1.0)}).javaId(class_2248.method_9507((class_2680)state)).stateGroupId(blockId).build();
            event.registerOverride(javaBlockState, stateBuilder.build());
        }
    }

    public static CustomBlockState.Builder blockStateBuilder(CustomBlockData customBlockData, class_2680 state) {
        CustomBlockState.Builder stateBuilder = customBlockData.blockStateBuilder();
        block5: for (class_2769 property : state.method_28501()) {
            class_2769 class_27692;
            Objects.requireNonNull(property);
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{class_2758.class, class_2746.class, class_2754.class}, (Object)class_27692, n)) {
                case 0: {
                    class_2758 intProperty = (class_2758)class_27692;
                    stateBuilder.intProperty(property.method_11899(), ((Integer)state.method_11654((class_2769)intProperty)).intValue());
                    continue block5;
                }
                case 1: {
                    class_2746 booleanProperty = (class_2746)class_27692;
                    stateBuilder.booleanProperty(property.method_11899(), ((Boolean)state.method_11654((class_2769)booleanProperty)).booleanValue());
                    continue block5;
                }
                case 2: {
                    class_2754 enumProperty = (class_2754)class_27692;
                    stateBuilder.stringProperty(enumProperty.method_11899(), ((class_3542)((Enum)((Object)state.method_11654((class_2769)enumProperty)))).method_15434());
                    continue block5;
                }
            }
            throw new IllegalArgumentException("Unknown property type: " + property.getClass().getName());
        }
        return stateBuilder;
    }

    private static NonVanillaCustomBlockData registerBackpackBlock(class_2248 block, class_2960 location) {
        return BackpackGeyserBlock.createHorizontalBlock(block, location).booleanProperty(BackpackBlock.HAS_DYE.method_11899()).intProperty(BackpackBlock.SLOTS.method_11899(), slots).stringProperty(BackpackBlock.DYE_COLOR.method_11899(), dye_colors).permutations(BackpackGeyserBlock.createBackpackPermutations()).name(location.method_12832()).namespace(location.method_12836()).build();
    }

    private static NonVanillaCustomBlockData.Builder createHorizontalBlock(class_2248 block, class_2960 location) {
        BoxComponent collisionBox = BoxComponent.fullBox();
        BoxComponent selectionBox = BoxComponent.fullBox();
        CustomBlockComponents components = CustomBlockComponents.builder().collisionBox(collisionBox).selectionBox(selectionBox).materialInstance("*", MaterialInstance.builder().texture("serverbackpacks:" + location.method_12832()).renderMethod("opaque").faceDimming(true).ambientOcclusion(true).build()).geometry(GeometryComponent.builder().identifier("geometry.backpack_3").build()).collisionBox(collisionBox).selectionBox(selectionBox).lightEmission(Integer.valueOf(block.method_9564().method_26213())).lightDampening(Integer.valueOf(block.method_9564().method_26193())).destructibleByMining(Float.valueOf(block.method_36555())).friction(Float.valueOf(Math.min(1.0f - block.method_9499(), 0.9f))).build();
        return NonVanillaCustomBlockData.builder().stringProperty(BackpackBlock.field_11177.method_11899(), facing).name(location.method_12832()).namespace(location.method_12836()).components(components);
    }

    private static List<CustomBlockPermutation> createHorizontalBlockPermutations() {
        ArrayList<CustomBlockPermutation> permutations = new ArrayList<CustomBlockPermutation>();
        Iterator<String> iterator = facing.iterator();
        while (iterator.hasNext()) {
            String direction;
            CustomBlockComponents customBlockComponents = CustomBlockComponents.builder().transformation(new TransformationComponent(0, (360 - (switch (direction = iterator.next()) {
                case "south" -> 180;
                case "west" -> 270;
                case "east" -> 90;
                default -> 0;
            })) % 360, 0)).build();
            permutations.add(new CustomBlockPermutation(customBlockComponents, String.format(STATE_CONDITION, BackpackBlock.field_11177.method_11899(), "'" + direction.toLowerCase() + "'")));
        }
        return permutations;
    }

    private static List<CustomBlockPermutation> createBackpackPermutations() {
        ArrayList<CustomBlockPermutation> permutations = new ArrayList<CustomBlockPermutation>(BackpackGeyserBlock.createHorizontalBlockPermutations());
        for (int size : slots) {
            permutations.addAll(BackpackGeyserBlock.createDyePermutations(size));
            permutations.add(BackpackGeyserBlock.createGeometryPermutation(size));
        }
        return permutations;
    }

    private static List<CustomBlockPermutation> createDyePermutations(int size) {
        ArrayList<CustomBlockPermutation> dyePermutations = new ArrayList<CustomBlockPermutation>();
        for (String dyeColor : dye_colors) {
            CustomBlockComponents customBlockComponents = CustomBlockComponents.builder().materialInstance("*", MaterialInstance.builder().texture("serverbackpacks:" + dyeColor + "_" + size).renderMethod("opaque").faceDimming(true).ambientOcclusion(true).build()).build();
            dyePermutations.add(new CustomBlockPermutation(customBlockComponents, String.format(STATE_CONDITION, BackpackBlock.SLOTS.method_11899(), size) + " && " + String.format(STATE_CONDITION, BackpackBlock.DYE_COLOR.method_11899(), "'" + dyeColor.toLowerCase() + "'") + " && " + String.format(STATE_CONDITION, BackpackBlock.HAS_DYE.method_11899(), "true")));
        }
        CustomBlockComponents basicComponents = CustomBlockComponents.builder().materialInstance("*", MaterialInstance.builder().texture("serverbackpacks:" + size).renderMethod("opaque").faceDimming(true).ambientOcclusion(true).build()).build();
        dyePermutations.add(new CustomBlockPermutation(basicComponents, String.format(STATE_CONDITION, BackpackBlock.SLOTS.method_11899(), size) + " && " + String.format(STATE_CONDITION, BackpackBlock.HAS_DYE.method_11899(), "false")));
        return dyePermutations;
    }

    private static CustomBlockPermutation createGeometryPermutation(int size) {
        CustomBlockComponents customBlockComponents = CustomBlockComponents.builder().geometry(GeometryComponent.builder().identifier("geometry.backpack_" + size).build()).build();
        return new CustomBlockPermutation(customBlockComponents, String.format(STATE_CONDITION, BackpackBlock.SLOTS.method_11899(), size));
    }

    static {
        slots.add(1);
        slots.add(2);
        slots.add(3);
    }
}

