/*
 * Decompiled with CFR 0.152.
 */
package com.rouesvm.servback.compat.trinkets;

import com.rouesvm.servback.content.component.UpgradeContainerComponent;
import com.rouesvm.servback.content.item.BundleGuiItem;
import com.rouesvm.servback.registry.BackpackDataComponentTypes;
import com.rouesvm.servback.technical.config.Configuration;
import com.rouesvm.servback.technical.cosmetic.BackHolder;
import com.rouesvm.servback.technical.cosmetic.CosmeticManager;
import com.rouesvm.servback.technical.manager.BackpackManager;
import com.rouesvm.servback.technical.manager.BackpackUUID;
import dev.emi.trinkets.api.SlotReference;
import dev.emi.trinkets.api.Trinket;
import dev.emi.trinkets.api.TrinketComponent;
import dev.emi.trinkets.api.TrinketInventory;
import dev.emi.trinkets.api.TrinketItem;
import dev.emi.trinkets.api.TrinketsApi;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_3222;
import net.minecraft.class_3965;
import net.minecraft.class_7923;

public class BackpackTrinket
implements Trinket {
    public static void initialize() {
        UseBlockCallback.EVENT.register(BackpackTrinket::tryPlaceBackpack);
        class_7923.field_41178.method_10220().filter(item -> item instanceof BundleGuiItem).forEach(item -> TrinketsApi.registerTrinket((class_1792)item, (Trinket)new BackpackTrinket()));
    }

    public void tick(class_1799 stack, SlotReference slot, class_1309 entity) {
        if (!Configuration.instance().display_back) {
            return;
        }
        if (entity instanceof class_3222) {
            UUID uuid;
            class_3222 player = (class_3222)entity;
            CosmeticManager manager = CosmeticManager.manager();
            if (!manager.hasInstance(player)) {
                manager.getOrCreateInstance(player, stack);
            }
            if ((uuid = BackpackUUID.getStackUUID(stack)) == null) {
                return;
            }
            UpgradeContainerComponent component = (UpgradeContainerComponent)stack.method_58694(BackpackDataComponentTypes.UPGRADE_CONTAINER);
            if (component != null) {
                component.getBaseUpgrades().forEach(upgrade -> upgrade.tick((class_1937)player.method_51469(), player.method_73189(), BackpackManager.getInventory(uuid)));
            }
        }
    }

    public void onEquip(class_1799 stack, SlotReference slot, class_1309 entity) {
        if (!Configuration.instance().display_back) {
            return;
        }
        if (entity instanceof class_3222) {
            class_3222 player = (class_3222)entity;
            CosmeticManager.manager().getOrCreateInstance(player, stack);
        }
    }

    public void onUnequip(class_1799 stack, SlotReference slot, class_1309 entity) {
        if (!Configuration.instance().display_back) {
            return;
        }
        if (entity instanceof class_3222) {
            class_3222 player = (class_3222)entity;
            CosmeticManager manager = CosmeticManager.manager();
            BackHolder holder = manager.getOrCreateInstance(player, stack);
            holder.destroy();
            manager.removeInstance(player);
        }
    }

    public static class_1269 tryPlaceBackpack(class_1657 player, class_1937 world, class_1268 hand, class_3965 blockHitResult) {
        if (!world.method_8608()) {
            if (!Configuration.instance().placeable) {
                return class_1269.field_5811;
            }
            class_1799 stack = BackpackTrinket.getStackInBackSlot(player);
            if (!stack.method_7960() && player.method_5715() && player.method_6047().method_7960() && player.method_6079().method_7960()) {
                BundleGuiItem item = (BundleGuiItem)stack.method_7909();
                class_1750 context = new class_1750(player, hand, stack, blockHitResult);
                item.method_7712(context);
                return class_1269.field_5812;
            }
        }
        return class_1269.field_5811;
    }

    public static void equipStack(class_1657 player, class_1799 stack) {
        TrinketItem.equipItem((class_1657)player, (class_1799)stack);
    }

    public static boolean isBackSlotOccupied(class_1657 player) {
        return !BackpackTrinket.getStackInBackSlot(player).method_7960();
    }

    private static class_1799 getStackInBackSlot(class_1657 player) {
        return TrinketsApi.getTrinketComponent((class_1309)player).map(BackpackTrinket::findBundleItem).orElse(class_1799.field_8037);
    }

    private static class_1799 findBundleItem(TrinketComponent component) {
        for (Map group : component.getInventory().values()) {
            for (TrinketInventory inv : group.values()) {
                for (int i = 0; i < inv.method_5439(); ++i) {
                    class_1799 stack = inv.method_5438(i);
                    if (stack.method_7960() || !(stack.method_7909() instanceof BundleGuiItem)) continue;
                    return stack;
                }
            }
        }
        return class_1799.field_8037;
    }
}

