/*
 * Decompiled with CFR 0.152.
 */
package com.rouesvm.servback.content.recipe;

import com.rouesvm.servback.content.component.UpgradeComponent;
import com.rouesvm.servback.content.item.UpgradeItem;
import com.rouesvm.servback.content.upgrade.FilterableUpgrade;
import com.rouesvm.servback.content.upgrade.Upgrade;
import com.rouesvm.servback.content.upgrade.extension.ItemFilter;
import com.rouesvm.servback.registry.BackpackDataComponentTypes;
import com.rouesvm.servback.registry.BackpackRecipeRegistry;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1852;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6885;
import net.minecraft.class_7225;
import net.minecraft.class_7710;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.class_9694;

public class InputDefinedFilterRecipe
extends class_1852 {
    public static final class_1865<InputDefinedFilterRecipe> SERIALIZER = new Serializer((class_1852.class_1866.class_7711<InputDefinedFilterRecipe>)((class_1852.class_1866.class_7711)InputDefinedFilterRecipe::new));

    public InputDefinedFilterRecipe(class_7710 category) {
        super(category);
    }

    public boolean matches(class_9694 input, class_1937 world) {
        if (input.method_59987()) {
            return false;
        }
        if (input.method_59990() > 6) {
            return false;
        }
        int magnetCount = 0;
        ObjectOpenHashSet seenItems = new ObjectOpenHashSet(5);
        for (class_1799 stack : input.method_59989()) {
            if (stack.method_7960()) continue;
            class_1792 item = stack.method_7909();
            if (item instanceof UpgradeItem) {
                ++magnetCount;
                continue;
            }
            if (seenItems.add(this.getItemKey(stack))) continue;
            return false;
        }
        int totalItems = seenItems.size();
        return totalItems > 0 && totalItems <= 5 && magnetCount == 1;
    }

    public class_1799 craft(class_9694 input, class_7225.class_7874 registries) {
        class_1799 stack = this.findUpgradeStack(input);
        if (stack.method_7960()) {
            return class_1799.field_8037;
        }
        UpgradeComponent oldComponent = (UpgradeComponent)stack.method_58694(BackpackDataComponentTypes.UPGRADE);
        if (oldComponent == null) {
            return class_1799.field_8037;
        }
        Set<String> uniqueItems = this.extractFilterKeysFromInput(stack, input);
        if (uniqueItems.isEmpty()) {
            return class_1799.field_8037;
        }
        return this.getResultStack(oldComponent, stack, uniqueItems);
    }

    private class_1799 getResultStack(UpgradeComponent oldComponent, class_1799 center, Set<String> uniqueItems) {
        Upgrade oldUpgrade = oldComponent.upgrade();
        Upgrade upgrade = oldUpgrade.getType().create();
        if (!(upgrade instanceof FilterableUpgrade)) {
            return class_1799.field_8037;
        }
        FilterableUpgrade newUpgrade = (FilterableUpgrade)((Object)upgrade);
        ItemFilter filter = newUpgrade.getFilter();
        filter.filterList().addAll(uniqueItems);
        filter.setMode(((FilterableUpgrade)((Object)oldUpgrade)).getFilter().getMode());
        class_1799 result = center.method_7972();
        result.method_57379(BackpackDataComponentTypes.UPGRADE, (Object)UpgradeComponent.of(upgrade));
        return result;
    }

    private class_1799 findUpgradeStack(class_9694 input) {
        for (class_1799 stack : input.method_59989()) {
            UpgradeComponent component;
            if (stack.method_7960() || (component = (UpgradeComponent)stack.method_58694(BackpackDataComponentTypes.UPGRADE)) == null || !(component.upgrade() instanceof FilterableUpgrade)) continue;
            return stack;
        }
        return class_1799.field_8037;
    }

    private Set<String> extractFilterKeysFromInput(class_1799 filterStack, class_9694 input) {
        ObjectOpenHashSet uniqueItems = new ObjectOpenHashSet(5);
        for (class_1799 stack : input.method_59989()) {
            if (uniqueItems.size() >= 5) break;
            if (stack.method_7960() || stack.method_31574(filterStack.method_7909())) continue;
            uniqueItems.add(this.getItemKey(stack));
        }
        return uniqueItems;
    }

    private String parseTagNameFromStack(class_1799 stack) {
        String tagString = stack.method_7964().getString();
        if (!tagString.startsWith("#")) {
            return null;
        }
        class_2960 tagId = class_2960.method_12829((String)tagString.substring(1));
        if (tagId == null) {
            return null;
        }
        class_6862 tag = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)tagId);
        Optional tagKey = class_7923.field_41178.method_46733(tag);
        if (tagKey.isEmpty()) {
            return null;
        }
        if (!stack.method_53187((class_6885)tagKey.get())) {
            return null;
        }
        return tagString;
    }

    private String getItemKey(class_1799 stack) {
        class_2960 itemId = class_7923.field_41178.method_10221((Object)stack.method_7909());
        String itemKey = itemId.toString();
        String tagKey = this.parseTagNameFromStack(stack);
        return this.hasCustomName(stack) && tagKey != null ? tagKey : itemKey;
    }

    private boolean hasCustomName(class_1799 stack) {
        return stack.method_65130() != null;
    }

    public class_2371<class_1799> method_17704(class_9694 input) {
        class_2371 remainders = class_2371.method_10213((int)input.method_59983(), (Object)class_1799.field_8037);
        for (int i = 0; i < input.method_59983(); ++i) {
            class_1799 stack = input.method_59984(i);
            if (stack.method_7909() instanceof UpgradeItem) continue;
            remainders.set(i, (Object)stack.method_51164());
        }
        return remainders;
    }

    public class_1865<InputDefinedFilterRecipe> method_8119() {
        return BackpackRecipeRegistry.MAGNET_FILTER_APPLIER_RECIPE;
    }

    public class_7710 method_45441() {
        return class_7710.field_40251;
    }

    public static class Serializer
    extends class_1852.class_1866<InputDefinedFilterRecipe> {
        public Serializer(class_1852.class_1866.class_7711<InputDefinedFilterRecipe> factory) {
            super(factory);
        }

        public class_9139<class_9129, InputDefinedFilterRecipe> method_56104() {
            return null;
        }
    }
}

