/*
 * Decompiled with CFR 0.152.
 */
package com.rouesvm.servback.registry.item;

import com.rouesvm.servback.ServerBackpacks;
import com.rouesvm.servback.content.item.impl.ContainerItem;
import com.rouesvm.servback.registry.item.BackpackItemRegistry;
import com.rouesvm.servback.technical.config.BackpackItemConfiguration;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1767;
import net.minecraft.class_1792;

public class BackpackItemJsonRegistry {
    public static final Set<class_1792> BACKPACKS = new ObjectOpenHashSet();
    public static final Map<class_1792, String> BACKPACKS_TO_NAME = new Object2ObjectOpenHashMap();
    public static final Map<String, class_1792> NAME_TO_BACKPACK = new Object2ObjectOpenHashMap();
    public static final Map<String, Set<class_1792>> NAME_TO_BACKPACKS = new Object2ObjectOpenHashMap();
    public static final Map<class_1792, class_1792> ITEM_TO_UPGRADED = new Object2ObjectOpenHashMap();
    public static final Map<class_1792, String> ITEM_TO_UPGRADED_STRING = new Object2ObjectOpenHashMap();
    public static final Map<class_1792, class_1767> ITEM_TO_DYE = new Object2ObjectOpenHashMap();
    public static final Map<class_1792, BackpackItemConfiguration.BackCosmetic> ITEM_TO_BACK_COSMETIC = new Object2ObjectOpenHashMap();

    public static Set<class_1792> getBackpacksByName(String name) {
        return NAME_TO_BACKPACKS.get(name);
    }

    public static class_1792 getBackpackByName(String name) {
        return NAME_TO_BACKPACK.get(name);
    }

    public static class_1792 getBackpackUpgrade(class_1792 item) {
        return ITEM_TO_UPGRADED.get(item);
    }

    public static String getBackpackUpgradeName(class_1792 item) {
        return BACKPACKS_TO_NAME.get(ITEM_TO_UPGRADED.get(item));
    }

    public static class_1767 getBackpackDyeColor(ContainerItem item) {
        return ITEM_TO_DYE.get(item);
    }

    public static BackpackItemConfiguration.BackCosmetic getBackpackCosmetic(ContainerItem item) {
        return ITEM_TO_BACK_COSMETIC.getOrDefault(item, BackpackItemConfiguration.DEFAULT_COSMETIC);
    }

    private static ContainerItem create(String upgrade, String name, int slots) {
        ContainerItem item = BackpackItemRegistry.register(new ContainerItem(name, slots));
        BACKPACKS.add((class_1792)item);
        BACKPACKS_TO_NAME.put((class_1792)item, name);
        NAME_TO_BACKPACK.put(name, (class_1792)item);
        if (!upgrade.isEmpty()) {
            ITEM_TO_UPGRADED_STRING.put((class_1792)item, upgrade);
        }
        return item;
    }

    private static int registerBackpacks(BackpackItemConfiguration.BackpackDefinedType type) {
        HashSet<ContainerItem> items = new HashSet<ContainerItem>();
        if (!NAME_TO_BACKPACK.containsKey(type.backpack())) {
            items.add(BackpackItemJsonRegistry.create(type.upgradeBackpack(), type.backpack(), type.slots()));
            if (type.dyeable()) {
                List<String> blacklistedDyes = type.dyeBlacklist();
                for (class_1767 color : class_1767.values()) {
                    String dyeColor = color.name().toLowerCase();
                    if (blacklistedDyes != null && blacklistedDyes.contains(dyeColor)) continue;
                    ContainerItem item = BackpackItemJsonRegistry.create(dyeColor + "_" + type.upgradeBackpack(), dyeColor + "_" + type.backpack(), type.slots());
                    items.add(item);
                    ITEM_TO_DYE.put((class_1792)item, color);
                }
            }
            NAME_TO_BACKPACKS.put(type.backpack(), items);
        }
        for (class_1792 class_17922 : items) {
            ITEM_TO_BACK_COSMETIC.put(class_17922, type.cosmetic());
        }
        return items.size();
    }

    public static void initialize() {
        List<BackpackItemConfiguration.BackpackDefinedType> configuration = BackpackItemConfiguration.manager.backpackTypes;
        int registeredSize = 0;
        for (BackpackItemConfiguration.BackpackDefinedType backpackDefinedType : configuration) {
            registeredSize += BackpackItemJsonRegistry.registerBackpacks(backpackDefinedType);
        }
        for (class_1792 backpack : BACKPACKS) {
            String upgradeName = ITEM_TO_UPGRADED_STRING.get(backpack);
            ITEM_TO_UPGRADED.put(backpack, NAME_TO_BACKPACK.get(upgradeName));
        }
        ServerBackpacks.LOGGER.info("Finished registering {} items.", (Object)registeredSize);
    }
}

