/*
 * Decompiled with CFR 0.152.
 */
package com.rouesvm.servback.technical;

import com.rouesvm.servback.ServerBackpacks;
import com.rouesvm.servback.content.item.impl.ContainerItem;
import com.rouesvm.servback.technical.data.BackpackInstance;
import com.rouesvm.servback.technical.manager.BackpackManager;
import com.rouesvm.servback.technical.manager.BackpackUUID;
import com.rouesvm.servback.technical.ui.inventory.BackpackInventory;
import java.lang.invoke.CallSite;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_9279;
import net.minecraft.class_9334;

public class BackpackUtils {
    public static String hashBackpackContents(class_2371<class_1799> items) {
        HashMap<CallSite, Integer> contents = new HashMap<CallSite, Integer>();
        for (class_1799 stack : items) {
            if (stack.method_7960()) continue;
            int componentHash = stack.method_57353().hashCode();
            String key = stack.method_7909().toString() + ":" + componentHash;
            contents.merge((CallSite)((Object)key), stack.method_7947(), Integer::sum);
        }
        return contents.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(e -> (String)e.getKey() + "=" + String.valueOf(e.getValue())).collect(Collectors.joining(","));
    }

    public static void convertComponentToBackpackData(BackpackInstance instance, class_1799 stack) {
        BackpackInventory inventory = instance.inventory();
        class_1792 class_17922 = stack.method_7909();
        if (!(class_17922 instanceof ContainerItem)) {
            return;
        }
        ContainerItem item = (ContainerItem)class_17922;
        if (!inventory.method_5442()) {
            return;
        }
        if (stack.method_58694(class_9334.field_49622) == null) {
            return;
        }
        class_2371<class_1799> itemStacks = item.getComponentItemList(stack);
        if (inventory.insertItems(itemStacks)) {
            instance.copyToInventory(inventory);
            BackpackManager.addBackpack(instance);
        }
        stack.method_57379(class_9334.field_49622, null);
    }

    public static class_2371<class_1799> getItemList(class_1799 stack) {
        UUID uuid = BackpackUUID.getStackUUID(stack);
        BackpackInventory inventory = BackpackManager.getInventory(uuid);
        if (inventory != null) {
            class_2371 stacks = class_2371.method_37434((int)inventory.method_5439());
            stacks.addAll(inventory.heldStacks());
            return stacks;
        }
        return class_2371.method_10211();
    }

    public static int getExtendedSlots(class_1799 stack) {
        class_9279 component = (class_9279)stack.method_58695(class_9334.field_49628, (Object)class_9279.field_49302);
        class_2487 compound = component.method_57461();
        return 9 * compound.method_68083("level", 0);
    }

    public static int addCustomData(class_3218 world, class_1799 stack) {
        Optional capacity;
        class_5455 registryManager = world.method_30349();
        Optional enchantmentReference = registryManager.method_46759(class_7924.field_41265);
        int level = 0;
        if (enchantmentReference.isPresent() && (capacity = ((class_2378)enchantmentReference.get()).method_46746(ServerBackpacks.CAPACITY)).isPresent()) {
            level = stack.method_58657().method_57536((class_6880)capacity.get());
            class_2487 compound = new class_2487();
            compound.method_10569("level", level);
            stack.method_57379(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)compound));
        }
        return 9 * level;
    }

    public static void resizeIfIncorrectSize(class_3222 player, class_1799 stack, int maxBackpackSlot) {
        UUID uuid = BackpackUUID.getStackUUID(stack);
        BackpackInventory inventory = BackpackManager.getInventory(uuid);
        if (inventory != null) {
            BackpackUtils.resize(player, uuid, inventory, maxBackpackSlot + BackpackUtils.addCustomData(player.method_51469(), stack));
        }
    }

    public static void dropExcessItems(class_3222 player, BackpackInventory target, int totalSlots) {
        for (int i = target.method_5439() - 1; i >= totalSlots; --i) {
            class_1799 excessItem = i < target.heldStacks().size() ? (class_1799)target.heldStacks().get(i) : class_1799.field_8037;
            player.method_7328(excessItem, true);
        }
        ContainerItem.playDropContentsSound(player, -0.2f);
    }

    public static void resize(class_3222 player, UUID uuid, BackpackInventory target, int totalSlots) {
        if (target.method_5439() != totalSlots) {
            BackpackUtils.dropExcessItems(player, target, totalSlots);
            BackpackInventory.resizeInventory(uuid, totalSlots);
        }
    }
}

