/*
 * Decompiled with CFR 0.152.
 */
package com.rouesvm.servback.technical.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.rouesvm.servback.ServerBackpacks;
import com.rouesvm.servback.technical.config.BackpackConfigurationFixer;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import net.fabricmc.loader.api.FabricLoader;
import org.joml.Vector3f;

public class BackpackItemConfiguration {
    public static final BackCosmetic DEFAULT_COSMETIC = new BackCosmetic(new Vector3f(0.0f, -0.45f, 0.28f), 180, -25);
    public static final BackpackDefinedType DEFAULT_SMALL = new BackpackDefinedType("small", "medium", 9, true, List.of(), DEFAULT_COSMETIC);
    public static final BackpackDefinedType DEFAULT_MEDIUM = new BackpackDefinedType("medium", "large", 18, true, List.of(), DEFAULT_COSMETIC);
    public static final BackpackDefinedType DEFAULT_LARGE = new BackpackDefinedType("large", "", 27, true, List.of(), DEFAULT_COSMETIC);
    public static BackpackItemConfiguration manager;
    private static final Gson GSON;
    public Path configDir = FabricLoader.getInstance().getConfigDir().resolve("serverbackpacks/backpacks/");
    public List<BackpackDefinedType> backpackTypes;

    public BackpackItemConfiguration() {
        try {
            if (!Files.exists(this.configDir, new LinkOption[0])) {
                Files.createDirectories(this.configDir, new FileAttribute[0]);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void createDefaultFiles() {
        Path small = this.configDir.resolve("small.json");
        Path medium = this.configDir.resolve("medium.json");
        Path large = this.configDir.resolve("large.json");
        try {
            boolean anyFileExists;
            try (Stream<Path> files = Files.list(this.configDir);){
                anyFileExists = files.findAny().isPresent();
            }
            if (anyFileExists) {
                return;
            }
            this.createDefaultFile(small, DEFAULT_SMALL);
            this.createDefaultFile(medium, DEFAULT_MEDIUM);
            this.createDefaultFile(large, DEFAULT_LARGE);
            ServerBackpacks.LOGGER.info("Created default backpack configs in {}", (Object)this.configDir);
        }
        catch (IOException e) {
            ServerBackpacks.LOGGER.error("Failed to check or create default backpack files: {}", (Object)e.getMessage());
        }
    }

    private void createDefaultFile(Path path, BackpackDefinedType data) {
        try (FileWriter writer = new FileWriter(path.toFile());){
            GSON.toJson((Object)data, (Appendable)writer);
        }
        catch (IOException e) {
            ServerBackpacks.LOGGER.error("Failed to create default file {}: {}", (Object)path.getFileName(), (Object)e.getMessage());
        }
    }

    public void loadAllBackpacks() {
        this.backpackTypes = new ArrayList<BackpackDefinedType>();
        if (System.getProperty("fabric-api.datagen") != null) {
            ServerBackpacks.LOGGER.info("Using default backpack configs.");
            this.backpackTypes.add(DEFAULT_SMALL);
            this.backpackTypes.add(DEFAULT_MEDIUM);
            this.backpackTypes.add(DEFAULT_LARGE);
            return;
        }
        if (!Files.exists(this.configDir, new LinkOption[0])) {
            try {
                Files.createDirectories(this.configDir, new FileAttribute[0]);
            }
            catch (IOException e) {
                ServerBackpacks.LOGGER.error("Failed to recreate config directory: {}", (Object)e.getMessage());
                return;
            }
        }
        try (Stream<Path> files = Files.list(this.configDir);){
            files.filter(path -> path.toString().endsWith(".json")).forEach(path -> {
                try (FileReader reader = new FileReader(path.toFile());){
                    JsonElement rawJson = JsonParser.parseReader((Reader)reader);
                    if (rawJson.isJsonArray()) {
                        BackpackDefinedType[] loaded = (BackpackDefinedType[])GSON.fromJson(rawJson, BackpackDefinedType[].class);
                        this.backpackTypes.addAll(Arrays.asList(loaded));
                    } else {
                        BackpackDefinedType loaded = (BackpackDefinedType)GSON.fromJson(rawJson, BackpackDefinedType.class);
                        this.backpackTypes.add(loaded);
                    }
                    ServerBackpacks.LOGGER.info("Loaded backpack config: {}", (Object)path.getFileName());
                }
                catch (Exception e) {
                    ServerBackpacks.LOGGER.warn("Failed to load backpack file {}: {}", (Object)path.getFileName(), (Object)e.getMessage());
                }
            });
        }
        catch (IOException e) {
            ServerBackpacks.LOGGER.error("Error reading backpack config directory: {}", (Object)e.getMessage());
        }
    }

    public void saveDefinedBackpacks() {
        if (!Files.exists(this.configDir, new LinkOption[0])) {
            try {
                Files.createDirectories(this.configDir, new FileAttribute[0]);
            }
            catch (IOException e) {
                ServerBackpacks.LOGGER.error("Failed to create config directory: {}", (Object)e.getMessage());
                return;
            }
        }
        for (BackpackDefinedType type : this.backpackTypes) {
            Path file = this.configDir.resolve(type.backpack() + ".json");
            try (FileWriter writer = new FileWriter(file.toFile());){
                GSON.toJson((Object)type, (Appendable)writer);
                ServerBackpacks.LOGGER.info("Saved backpack config: {}", (Object)file.getFileName());
            }
            catch (IOException e) {
                ServerBackpacks.LOGGER.error("Failed to save backpack {}: {}", (Object)type.backpack(), (Object)e.getMessage());
            }
        }
    }

    public static void initialize() {
        manager = new BackpackItemConfiguration();
        List<BackpackDefinedType> definedTypes = BackpackConfigurationFixer.convertOldConfigToNew();
        if (definedTypes.isEmpty()) {
            manager.createDefaultFiles();
            manager.loadAllBackpacks();
        } else {
            BackpackItemConfiguration.manager.backpackTypes = definedTypes;
            manager.saveDefinedBackpacks();
        }
        if (BackpackItemConfiguration.manager.backpackTypes.isEmpty()) {
            ServerBackpacks.LOGGER.warn("No valid backpack configs found even after defaults.");
        }
        BackpackItemConfiguration.manager.backpackTypes.forEach(type -> ServerBackpacks.LOGGER.debug("Loaded: {} with {} slots.", (Object)type.backpack(), (Object)type.slots()));
    }

    static {
        GSON = new GsonBuilder().setPrettyPrinting().create();
    }

    public record BackpackDefinedType(String backpack, String upgradeBackpack, int slots, boolean dyeable, List<String> dyeBlacklist, BackCosmetic cosmetic) {
    }

    public record BackCosmetic(Vector3f offset, int yaw, int pitch_while_sneaking) {
    }
}

