/*
 * Decompiled with CFR 0.152.
 */
package com.rouesvm.servback.technical.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.google.gson.annotations.SerializedName;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1792;

public class Configuration {
    public static Configuration manager;
    private static final Gson GSON;
    private final File configFile;
    public Instance instance = new Instance();
    public List<BackpackType> backpackTypes = new ArrayList<BackpackType>();

    public static void initialize() {
        manager = new Configuration("serverbackpacks.json");
        manager.load();
        ServerLifecycleEvents.BEFORE_SAVE.register((a, c, b) -> manager.save());
    }

    public Configuration(String name) {
        Path configDir = FabricLoader.getInstance().getConfigDir().resolve("serverbackpacks/");
        try {
            if (!configDir.toFile().exists()) {
                Files.createDirectories(configDir, new FileAttribute[0]);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.configFile = configDir.resolve(name).toFile();
        if (!this.configFile.exists()) {
            this.save();
        }
    }

    public static Instance instance() {
        return Configuration.manager.instance;
    }

    public void save() {
        try (FileWriter writer = new FileWriter(this.configFile);){
            GSON.toJson((Object)this.instance, (Appendable)writer);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void load() {
        try (FileReader reader = new FileReader(this.configFile);){
            JsonElement rawJson = JsonParser.parseReader((Reader)reader);
            JsonObject jsonObject = rawJson.getAsJsonObject();
            Instance loaded = (Instance)GSON.fromJson(rawJson, Instance.class);
            if (loaded != null) {
                this.sanitizeConfig(jsonObject);
                this.convertTypesToList(jsonObject);
                this.convertOldTypeToList(jsonObject);
                this.instance = loaded;
            }
        }
        catch (JsonIOException | JsonSyntaxException | IOException throwable) {
            // empty catch block
        }
    }

    public void convertTypesToList(JsonObject jsonObject) {
        if (!jsonObject.has("types_of_backpacks")) {
            return;
        }
        JsonObject types = jsonObject.getAsJsonObject("types_of_backpacks");
        for (String keyStr : types.keySet()) {
            JsonObject oldType = types.getAsJsonObject(keyStr);
            if (oldType == null) continue;
            int key = Integer.parseInt(keyStr);
            int slots = oldType.has("slots") ? oldType.get("slots").getAsInt() : 9;
            boolean dyeable = oldType.has("dyeable") && oldType.get("dyeable").getAsBoolean();
            ArrayList<String> backpacks = new ArrayList<String>();
            if (oldType.has("backpacks")) {
                oldType.getAsJsonArray("backpacks").forEach(string -> backpacks.add(string.getAsString()));
            }
            ArrayList<String> dyeBlacklist = new ArrayList<String>();
            if (oldType.has("dyeBlacklist")) {
                oldType.getAsJsonArray("dyeBlacklist").forEach(e -> dyeBlacklist.add(e.getAsString()));
            }
            if (backpacks.isEmpty()) continue;
            this.backpackTypes.add(new BackpackType(slots, dyeable, backpacks, dyeBlacklist, key));
        }
    }

    public void convertOldTypeToList(JsonObject jsonObject) {
        if (!jsonObject.has("types_of_backpacks")) {
            return;
        }
        JsonObject types = jsonObject.getAsJsonObject("types_of_backpacks");
        for (String keyStr : types.keySet()) {
            JsonObject oldType = types.getAsJsonObject(keyStr);
            if (oldType == null) continue;
            int key = Integer.parseInt(keyStr);
            int slots = oldType.has("slots") ? oldType.get("slots").getAsInt() : 9;
            boolean dyeable = oldType.has("dyeable") && oldType.get("dyeable").getAsBoolean();
            ArrayList<String> backpacks = new ArrayList<String>();
            if (oldType.has("name")) {
                backpacks.add(oldType.get("name").getAsString());
            }
            ArrayList<String> dyeBlacklist = new ArrayList<String>();
            if (oldType.has("dyeBlacklist")) {
                oldType.getAsJsonArray("dyeBlacklist").forEach(e -> dyeBlacklist.add(e.getAsString()));
            }
            if (backpacks.isEmpty()) continue;
            this.backpackTypes.add(new BackpackType(slots, dyeable, backpacks, dyeBlacklist, key));
        }
    }

    public void sanitizeConfig(JsonObject jsonObject) {
        if (jsonObject.has("enable_globalpack") && !jsonObject.get("enable_globalpack").getAsBoolean()) {
            this.instance.disabled_backpacks.add("global");
        }
        if (jsonObject.has("enable_enderpack") && !jsonObject.get("enable_enderpack").getAsBoolean()) {
            this.instance.disabled_backpacks.add("ender");
        }
    }

    public static boolean isDisabled(class_1792 item) {
        String idString = item.toString();
        String removeNamespace = idString.replace("serverbackpacks:", "");
        if (removeNamespace.contains("upgrade") && !Configuration.instance().enable_upgrades) {
            return true;
        }
        return Configuration.instance().disabled_backpacks.contains(removeNamespace) || Configuration.instance().disabled_upgrades.contains(removeNamespace);
    }

    static {
        GSON = new GsonBuilder().setPrettyPrinting().create();
    }

    public static class Instance {
        @SerializedName(value="disabled_backpacks")
        public List<String> disabled_backpacks = List.of();
        @SerializedName(value="enable_upgrades")
        public boolean enable_upgrades = true;
        @SerializedName(value="disabled_upgrades")
        public List<String> disabled_upgrades = List.of();
        @SerializedName(value="placeable")
        public boolean placeable = true;
        @SerializedName(value="allow_backups")
        public boolean allow_backups = true;
        @SerializedName(value="breaks_with_flow")
        public boolean breaks_with_flow = true;
        @SerializedName(value="display_back")
        public boolean display_back = true;
    }

    public record BackpackType(int slots, boolean dyeable, List<String> backpacks, List<String> dyeBlacklist, int tier) {
    }
}

