/*
 * Decompiled with CFR 0.152.
 */
package com.rouesvm.servback.technical.cosmetic;

import com.rouesvm.servback.technical.cosmetic.BackHolder;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1799;
import net.minecraft.class_3222;

public class CosmeticManager {
    private static CosmeticManager manager = null;
    public Map<UUID, BackHolder> storedInstances = new Object2ObjectOpenHashMap();

    private CosmeticManager() {
    }

    public static CosmeticManager manager() {
        return manager;
    }

    public static void setup() {
        manager = new CosmeticManager();
    }

    public static void destroy() {
        if (manager != null) {
            CosmeticManager.manager.storedInstances.forEach((uuid, backHolder) -> backHolder.destroy());
            CosmeticManager.manager.storedInstances = new HashMap<UUID, BackHolder>();
            manager = null;
        }
    }

    public boolean hasInstance(class_3222 player) {
        return CosmeticManager.manager.storedInstances.get(player.method_5667()) != null;
    }

    public Optional<BackHolder> getInstance(class_3222 player) {
        return Optional.ofNullable(CosmeticManager.manager.storedInstances.getOrDefault(player.method_5667(), null));
    }

    public BackHolder getOrCreateInstance(class_3222 player, class_1799 stack) {
        Optional<BackHolder> holder = this.getInstance(player);
        if (holder.isEmpty()) {
            holder = Optional.of(BackHolder.createDisplay(stack, player));
            CosmeticManager.manager.storedInstances.put(player.method_5667(), holder.get());
        }
        return holder.get();
    }

    public void removeInstance(class_3222 player) {
        this.getInstance(player).ifPresent(h -> CosmeticManager.manager.storedInstances.remove(player.method_5667()));
    }
}

