/*
 * Decompiled with CFR 0.152.
 */
package com.rouesvm.servback.technical.manager;

import com.rouesvm.servback.ServerBackpacks;
import com.rouesvm.servback.technical.cosmetic.CosmeticManager;
import com.rouesvm.servback.technical.data.BackpackData;
import com.rouesvm.servback.technical.data.BackpackInstance;
import com.rouesvm.servback.technical.data.alternative.BackpackListData;
import com.rouesvm.servback.technical.data.alternative.BackpackState;
import com.rouesvm.servback.technical.data.alternative.BackpackStateUpper;
import com.rouesvm.servback.technical.data.state.GlobalBackpackState;
import com.rouesvm.servback.technical.ui.inventory.BackpackInventory;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class BackpackManager {
    private static BackpackManager instance;
    private final BackpackInventory globalInventory = new BackpackInventory(27);
    private final Map<UUID, BackpackInstance> storedInstances = new Object2ObjectOpenHashMap();
    private boolean loaded = false;
    private DATA_TYPE data_type = DATA_TYPE.NONE;
    private MinecraftServer server;

    public static void setup(MinecraftServer server) {
        if (ServerBackpacks.hasTrinketLoaded) {
            CosmeticManager.setup();
        }
        instance = new BackpackManager();
        BackpackManager.instance.server = server;
        BackpackManager.load(server);
        ServerBackpacks.LOGGER.info("Loading Server Backpack's data on server starting...");
        BackpackData.createBackupDirs(server);
    }

    public static void destroy(MinecraftServer ignoredServer) {
        CosmeticManager.destroy();
        if (instance != null) {
            ServerBackpacks.LOGGER.info("Saving Server Backpacks's data!");
            BackpackManager.saveData();
            BackpackManager.createBackup();
            instance = null;
        }
    }

    public void loadIntoStoredInstances(Set<BackpackInstance> instances) {
        instances.forEach(backpackInstance -> this.storedInstances.put(backpackInstance.uuid(), (BackpackInstance)backpackInstance));
    }

    public static void createBackup() {
        BackpackManager.saveData();
        BackpackData.createBackup(BackpackManager.server());
    }

    public static void createSingularBackup(BackpackInstance instance) {
        BackpackData.saveSingle(BackpackManager.server(), instance);
        BackpackData.createSingularBackup(BackpackManager.server(), instance);
    }

    public static void saveData(BackpackInstance instance) {
        BackpackData.replaceStoredInventory(instance);
        BackpackData.saveSingle(BackpackManager.server(), instance);
    }

    public static void loadFallback(MinecraftServer server, boolean loadState) {
        if (BackpackListData.loadData(server, BackpackManager.instance.loaded)) {
            BackpackManager.instance.loaded = true;
            BackpackManager.instance.data_type = DATA_TYPE.LIST_FILE_DATA;
        }
        if (loadState && BackpackState.loadData(server, BackpackManager.instance.loaded)) {
            BackpackManager.instance.loaded = true;
            BackpackManager.instance.data_type = DATA_TYPE.MINECRAFT_STATE;
        }
        if (BackpackStateUpper.loadData(server, BackpackManager.instance.loaded)) {
            BackpackManager.instance.loaded = true;
            BackpackManager.instance.data_type = DATA_TYPE.OLD_MINECRAFT_STATE;
        }
    }

    public static void loadFileData(MinecraftServer server) {
        if (BackpackData.loadData(server, BackpackManager.instance.loaded)) {
            BackpackManager.instance.loaded = true;
            BackpackManager.instance.data_type = DATA_TYPE.FILE_DATA;
        }
    }

    public static void load(MinecraftServer server) {
        BackpackManager.loadFileData(server);
        if (!BackpackManager.instance.loaded) {
            BackpackManager.loadFallback(server, false);
        }
        if (!BackpackManager.instance.loaded) {
            ServerBackpacks.LOGGER.error("Failed to load Server Backpack's data.");
        } else {
            ServerBackpacks.LOGGER.info("Loaded {} format as Server Backpack's data.", (Object)BackpackManager.instance.data_type.toString());
        }
    }

    public static void loadOnServerStarted(MinecraftServer server) {
        if (!BackpackManager.instance.loaded) {
            ServerBackpacks.LOGGER.info("Running Server Backpack's data old format convertor...");
            BackpackManager.loadFallback(server, true);
        }
        GlobalBackpackState globalBackpackState = GlobalBackpackState.getServerState(server);
        BackpackManager.instance.globalInventory.setInventoryDirectly(globalBackpackState.globalInventory.heldStacks());
    }

    public static void saveData() {
        BackpackData.replaceStoredInventories(instance.backpackInstances());
        BackpackData.save(BackpackManager.server());
        GlobalBackpackState globalBackpackState = GlobalBackpackState.getServerState(BackpackManager.server());
        globalBackpackState.globalInventory = BackpackManager.instance.globalInventory;
    }

    public static void saveToBackpackInventory(BackpackInstance instance) {
        if (instance == null) {
            return;
        }
        if (instance.uuid() != null && instance.inventory() != null) {
            instance.setLastAccessed();
            Optional<BackpackInstance> saved = BackpackManager.addBackpack(instance);
            saved.ifPresent(savedInstance -> savedInstance.copyToInventory(instance.inventory()));
        }
    }

    public static Optional<BackpackInstance> addBackpack(BackpackInstance instance) {
        UUID uuid = instance.uuid();
        if (uuid == null || instance.inventory() == null) {
            return Optional.empty();
        }
        BackpackManager.instance.storedInstances().putIfAbsent(uuid, instance);
        return BackpackManager.getInstance(uuid);
    }

    public static void addBackpack(UUID uuid, BackpackInventory inventory) {
        BackpackManager.addBackpack(new BackpackInstance(uuid, inventory));
    }

    public static Optional<BackpackInstance> getInstance(UUID uuid) {
        BackpackInstance backpackInstance = instance.storedInstances().get(uuid);
        return Optional.ofNullable(backpackInstance);
    }

    public static Optional<BackpackInstance> getInstance(UUID uuid, int slots) {
        if (instance == null) {
            return Optional.empty();
        }
        if (instance.hasBackpack(uuid)) {
            BackpackInventory.resizeInventory(uuid, slots);
        } else {
            BackpackManager.addBackpack(uuid, new BackpackInventory(slots));
        }
        return BackpackManager.getInstance(uuid);
    }

    @Nullable
    public static BackpackInventory getInventory(UUID uuid) {
        return BackpackManager.getInstance(uuid).map(BackpackInstance::inventory).orElse(null);
    }

    public static BackpackManager instance() {
        return instance;
    }

    public static MinecraftServer server() {
        return BackpackManager.instance.server;
    }

    public Set<BackpackInstance> backpackInstances() {
        return new HashSet<BackpackInstance>(this.storedInstances.values());
    }

    public Map<UUID, BackpackInstance> storedInstances() {
        return this.storedInstances;
    }

    public static void setGlobalInventory(class_2371<class_1799> stacks) {
        BackpackManager.instance.globalInventory.setInventoryDirectly(stacks);
    }

    public static BackpackInventory globalInventory() {
        return BackpackManager.instance.globalInventory;
    }

    public boolean hasBackpack(UUID uuid) {
        Optional<BackpackInstance> backpackInstance = BackpackManager.getInstance(uuid);
        return uuid != null && backpackInstance.isPresent();
    }

    public static enum DATA_TYPE {
        NONE("No data loaded"),
        MINECRAFT_STATE("Minecraft state"),
        OLD_MINECRAFT_STATE("Old Minecraft state"),
        FILE_DATA("File-based data"),
        LIST_FILE_DATA("List file-based data");

        private final String description;

        private DATA_TYPE(String desc) {
            this.description = desc;
        }

        public String toString() {
            return this.description;
        }
    }
}

