/*
 * Decompiled with CFR 0.152.
 */
package com.lynxxdg.lynxMinecarts;

import org.bukkit.entity.EntityType;
import org.bukkit.entity.Minecart;
import org.bukkit.event.Listener;
import org.bukkit.event.vehicle.VehicleEnterEvent;
import org.bukkit.event.vehicle.VehicleExitEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventHandler
implements Listener {
    private static final Logger log = LoggerFactory.getLogger(EventHandler.class);
    private final double defaultSpeed;
    private final double fastSpeed;

    public EventHandler(double defaultSpeed, double fastSpeed) {
        this.defaultSpeed = defaultSpeed;
        this.fastSpeed = fastSpeed;
    }

    public static double ConvertSpeed(double blocksPerSecond) {
        return blocksPerSecond / 20.0;
    }

    @org.bukkit.event.EventHandler(ignoreCancelled=true)
    private void onVehicleEnter(VehicleEnterEvent event) {
        if (event.getVehicle().getType() != EntityType.MINECART) {
            return;
        }
        if (event.getEntered().getType() != EntityType.PLAYER) {
            return;
        }
        Minecart minecart = (Minecart)event.getVehicle();
        minecart.setMaxSpeed(EventHandler.ConvertSpeed(this.fastSpeed));
    }

    @org.bukkit.event.EventHandler(ignoreCancelled=true)
    private void onVehicleExit(VehicleExitEvent event) {
        if (event.getVehicle().getType() != EntityType.MINECART) {
            return;
        }
        Minecart minecart = (Minecart)event.getVehicle();
        minecart.setMaxSpeed(EventHandler.ConvertSpeed(this.defaultSpeed));
    }
}

