/*
 * Decompiled with CFR 0.152.
 */
package com.etfl.warputils.common.abstraction.commands;

import com.etfl.warputils.common.abstraction.commands.ICommandBuilder;
import com.etfl.warputils.common.abstraction.commands.wrappers.CommandContextWrapper;
import com.etfl.warputils.common.abstraction.commands.wrappers.CommandSourceWrapper;
import com.etfl.warputils.common.abstraction.commands.wrappers.ICommand;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.function.Predicate;
import net.minecraft.commands.CommandSourceStack;

public abstract class BaseCommandBuilder<T extends BaseCommandBuilder<T, B>, B extends ArgumentBuilder<CommandSourceStack, ?>>
implements ICommandBuilder<CommandSourceStack> {
    protected final B builder;

    protected BaseCommandBuilder(B builder) {
        this.builder = builder;
    }

    public T requires(Predicate<CommandSourceWrapper> requirement) {
        this.builder.requires(source -> requirement.test(new CommandSourceWrapper((CommandSourceStack)source)));
        return this.self();
    }

    public T then(ICommandBuilder<CommandSourceStack> child) {
        this.builder.then(child.build());
        return this.self();
    }

    public T executes(ICommand command) {
        this.builder.executes(context -> command.run(new CommandContextWrapper((CommandContext<CommandSourceStack>)context)));
        return this.self();
    }

    public B build() {
        return this.builder;
    }

    protected abstract T self();
}

