/*
 * Decompiled with CFR 0.152.
 */
package com.etfl.warputils.common.abstraction.config;

import com.etfl.warputils.common.abstraction.commands.LiteralCommandBuilder;
import com.etfl.warputils.common.abstraction.config.ConfigComponent;
import com.etfl.warputils.common.abstraction.config.fileManagement.ConfigFactory;
import com.etfl.warputils.common.abstraction.config.fileManagement.ConfigFileManager;
import com.etfl.warputils.common.abstraction.config.nbt.AbstractServerStateManager;
import com.etfl.warputils.common.abstraction.config.nbt.NbtCompound;
import com.etfl.warputils.common.utils.EventBus;
import com.etfl.warputils.platform.Services;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

public class ConfigManager {
    final String modID;
    private final String baseCommand;
    private final List<ConfigComponent> components = new ArrayList<ConfigComponent>();
    private final ConfigFileManager configFileManager;

    public ConfigManager(String modID) {
        this(modID, modID);
    }

    public ConfigManager(String modID, String baseCommand) {
        this(modID, baseCommand, null);
    }

    public ConfigManager(String modID, ConfigFactory configFactory) {
        this(modID, modID, configFactory);
    }

    public ConfigManager(String modID, String baseCommand, ConfigFactory configFactory) {
        this.modID = modID;
        this.baseCommand = baseCommand;
        this.configFileManager = configFactory != null ? configFactory.create(this::validateOrSetDefault) : null;
        EventBus.registerServerStartEvents(this::onServerStart);
    }

    private void onServerStart(MinecraftServer server) {
        this.resetSettings();
        AbstractServerStateManager state = Services.SERVER_STATE.get(server, this.modID + "_config", () -> this.toNbt(new NbtCompound()), this::fromNbt);
        this.setMarkDirtyRunnable(state::markDirty);
    }

    public void initialize() {
        this.registerCommands();
        if (this.configFileManager == null) {
            this.setDefaultSupplier(Map::of);
            return;
        }
        this.setDefaultSupplier(this.configFileManager::getConfig);
        this.configFileManager.getConfig();
    }

    private void setMarkDirtyRunnable(@NotNull Runnable runnable) {
        this.components.forEach(component -> component.setMarkDirtyRunnable(runnable));
    }

    private void setDefaultSupplier(@NotNull Supplier<Map<String, Object>> supplier) {
        this.components.forEach(component -> component.setDefaultSupplier(supplier));
    }

    private void resetSettings() {
        Map config = this.configFileManager != null ? this.configFileManager.getConfig() : Map.of();
        this.components.forEach(components -> components.fromMap(config));
    }

    private boolean validateOrSetDefault(@NotNull Map<String, Object> map) {
        boolean changed = false;
        for (ConfigComponent component : this.components) {
            changed |= component.validateOrSetDefault(map);
        }
        return changed |= this.validateMapOrder(map);
    }

    private boolean validateMapOrder(@NotNull Map<String, Object> map) {
        LinkedHashMap<String, Object> categoryMap = new LinkedHashMap<String, Object>(map);
        map.clear();
        this.components.forEach(component -> {
            String key = component.getName();
            map.put(key, categoryMap.get(key));
        });
        return !new ArrayList(categoryMap.keySet()).equals(new ArrayList<String>(map.keySet()));
    }

    private void registerCommands() {
        LiteralCommandBuilder baseCommand = LiteralCommandBuilder.literal(this.baseCommand);
        this.components.forEach(component -> component.initialize(baseCommand));
        baseCommand.then(((LiteralCommandBuilder)LiteralCommandBuilder.literal("reset").requires(serverCommandSource -> serverCommandSource.hasPermissionLevel(2))).executes(context -> this.setToDefault()));
        EventBus.addCommand(baseCommand);
    }

    private int setToDefault() {
        this.resetSettings();
        return 1;
    }

    public ConfigManager add(@NotNull ConfigComponent component) {
        this.components.add(component);
        return this;
    }

    public NbtCompound toNbt(NbtCompound nbt) {
        this.components.forEach(component -> component.toNbt(nbt));
        return nbt;
    }

    public void fromNbt(NbtCompound nbt) {
        this.components.forEach(component -> component.fromNbt(nbt));
    }
}

