/*
 * Decompiled with CFR 0.152.
 */
package com.etfl.warputils.common.abstraction.config.settings;

import com.etfl.warputils.common.abstraction.commands.wrappers.CommandContextWrapper;
import com.etfl.warputils.common.abstraction.commands.wrappers.argumentTypes.DoubleArgumentWrapper;
import com.etfl.warputils.common.abstraction.commands.wrappers.argumentTypes.IArgumentWrapper;
import com.etfl.warputils.common.abstraction.config.nbt.NbtCompound;
import com.etfl.warputils.common.abstraction.config.settings.ConfigSetting;
import java.util.function.Predicate;

public class DoubleConfigSetting
extends ConfigSetting<Double> {
    private final Predicate<Double> validator;

    public DoubleConfigSetting(String name, IArgumentWrapper<Double> argumentType, double defaultValue) {
        super(name, argumentType, defaultValue);
        this.validator = d -> true;
    }

    public DoubleConfigSetting(String name, IArgumentWrapper<Double> argumentType, double defaultValue, Predicate<Double> validator) {
        super(name, argumentType, defaultValue);
        this.validator = validator;
    }

    @Override
    Double getValue(CommandContextWrapper context) {
        return DoubleArgumentWrapper.getDouble(context, this.name);
    }

    @Override
    protected Double getOrDefault(Object value) {
        return this.isValid(value) ? ((Number)value).doubleValue() : ((Double)this.defaultValue).doubleValue();
    }

    @Override
    protected boolean isValid(Object value) {
        return value instanceof Number && this.validator.test(((Number)value).doubleValue());
    }

    @Override
    public void toNbt(NbtCompound nbt) {
        nbt.putDouble(this.name, (Double)this.value);
    }

    @Override
    public void fromNbt(NbtCompound nbt) {
        this.value = nbt.getDouble(this.name).filter(this.validator).orElse((Double)this.defaultSupplier.get());
    }
}

