/*
 * Decompiled with CFR 0.152.
 */
package com.etfl.warputils.common.abstraction.config.settings;

import com.etfl.warputils.common.abstraction.commands.wrappers.CommandContextWrapper;
import com.etfl.warputils.common.abstraction.commands.wrappers.argumentTypes.IArgumentWrapper;
import com.etfl.warputils.common.abstraction.commands.wrappers.argumentTypes.IntegerArgumentWrapper;
import com.etfl.warputils.common.abstraction.config.nbt.NbtCompound;
import com.etfl.warputils.common.abstraction.config.settings.ConfigSetting;
import java.util.function.Predicate;

public class IntConfigSetting
extends ConfigSetting<Integer> {
    private final Predicate<Integer> validator;

    public IntConfigSetting(String name, IArgumentWrapper<Integer> argumentType, int defaultValue) {
        super(name, argumentType, defaultValue);
        this.validator = i -> true;
    }

    public IntConfigSetting(String name, IArgumentWrapper<Integer> argumentType, int defaultValue, Predicate<Integer> validator) {
        super(name, argumentType, defaultValue);
        this.validator = validator;
    }

    @Override
    Integer getValue(CommandContextWrapper context) {
        return IntegerArgumentWrapper.getInteger(context, this.name);
    }

    @Override
    protected Integer getOrDefault(Object obj) {
        return this.isValid(obj) ? ((Number)obj).intValue() : ((Integer)this.defaultValue).intValue();
    }

    @Override
    protected boolean isValid(Object obj) {
        return obj instanceof Number && this.validator.test(((Number)obj).intValue());
    }

    @Override
    public void toNbt(NbtCompound nbt) {
        nbt.putInt(this.name, (Integer)this.value);
    }

    @Override
    public void fromNbt(NbtCompound nbt) {
        this.value = nbt.getInt(this.name).filter(this.validator).orElse((Integer)this.defaultSupplier.get());
    }
}

