/*
 * Decompiled with CFR 0.152.
 */
package com.etfl.warputils.common.abstraction.objects;

import com.etfl.warputils.Constants;
import com.etfl.warputils.common.abstraction.objects.EntityWrapper;
import com.etfl.warputils.common.data.Location;
import com.etfl.warputils.common.data.Vector3d;
import com.etfl.warputils.common.language.MessageManager;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Relative;
import net.minecraft.world.level.storage.LevelData;
import org.jetbrains.annotations.NotNull;

public class ServerPlayerWrapper
extends EntityWrapper<ServerPlayer> {
    public ServerPlayerWrapper(ServerPlayer player) {
        super(player);
    }

    public String getName() {
        return ((ServerPlayer)this.handle).getName().getString();
    }

    public void teleport(@NotNull Location location) {
        ResourceKey resourceKey = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)location.dimension()));
        ServerLevel level = ((ServerPlayer)this.handle).level().getServer().getLevel(resourceKey);
        if (level == null) {
            MessageManager.sendMessage(this, "common.teleport.invalid_dimension", false, new Object[0]);
            Constants.LOGGER.warn("Player {} tried to teleport to nonexistent dimension {}", (Object)((ServerPlayer)this.handle).getName(), (Object)location.dimension());
            return;
        }
        ((ServerPlayer)this.handle).teleportTo(level, location.pos().x(), location.pos().y(), location.pos().z(), EnumSet.noneOf(Relative.class), location.yaw(), location.pitch(), true);
    }

    public Location getLocation() {
        return new Location(((ServerPlayer)this.handle).level().dimension().location().toString(), new Vector3d(((ServerPlayer)this.handle).getX(), ((ServerPlayer)this.handle).getY(), ((ServerPlayer)this.handle).getZ()), ((ServerPlayer)this.handle).getYRot(), ((ServerPlayer)this.handle).getXRot());
    }

    public Location getWorldSpawn() {
        LevelData.RespawnData respawnData = ((ServerPlayer)this.handle).level().getServer().getRespawnData();
        BlockPos pos = respawnData.globalPos().pos();
        float yaw = respawnData.yaw();
        float pitch = respawnData.pitch();
        return new Location(respawnData.dimension().location().toString(), new Vector3d(pos.getX(), pos.getY(), pos.getZ()), yaw, pitch);
    }

    public long getTime() {
        return ((ServerPlayer)this.handle).level().getGameTime();
    }

    public MinecraftServer getServer() {
        return ((ServerPlayer)this.handle).level().getServer();
    }

    public ServerLevel getLevel() {
        return ((ServerPlayer)this.handle).level();
    }

    public boolean closeTo(Vector3d position, double delta) {
        double dx = Math.abs(position.x() - ((ServerPlayer)this.handle).getX());
        if (dx > delta) {
            return false;
        }
        double dy = Math.abs(position.y() - ((ServerPlayer)this.handle).getY());
        if (dy > delta) {
            return false;
        }
        double dz = Math.abs(position.z() - ((ServerPlayer)this.handle).getZ());
        return dz <= delta;
    }

    public void sendMessage(Component message, boolean overlay) {
        ((ServerPlayer)this.handle).sendSystemMessage(message, overlay);
    }
}

