/*
 * Decompiled with CFR 0.152.
 */
package com.etfl.warputils.common.data;

import com.etfl.warputils.common.abstraction.config.nbt.NbtCompound;
import com.etfl.warputils.common.data.Vector3d;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public record Location(String dimension, Vector3d pos, float yaw, float pitch) {
    private static final String DIMENSION_KEY = "dimension";
    private static final String POSITION_KEY = "pos";
    private static final String YAW_KEY = "yaw";
    private static final String PITCH_KEY = "pitch";

    @NotNull
    public NbtCompound toNbt() {
        NbtCompound nbt = new NbtCompound();
        nbt.putString(DIMENSION_KEY, this.dimension);
        nbt.putCompound(POSITION_KEY, this.pos.toNbt());
        nbt.putFloat(YAW_KEY, this.yaw);
        nbt.putFloat(PITCH_KEY, this.pitch);
        return nbt;
    }

    public static Optional<Location> fromNbt(@NotNull NbtCompound nbt) {
        Optional<String> dimension = nbt.getString(DIMENSION_KEY);
        Optional<NbtCompound> posNbt = nbt.getCompound(POSITION_KEY);
        Optional position = posNbt.flatMap(Vector3d::fromNbt);
        Optional<Float> yaw = nbt.getFloat(YAW_KEY);
        Optional<Float> pitch = nbt.getFloat(PITCH_KEY);
        if (dimension.isEmpty() || position.isEmpty() || yaw.isEmpty() || pitch.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new Location(dimension.get(), (Vector3d)position.get(), yaw.get().floatValue(), pitch.get().floatValue()));
    }
}

