/*
 * Decompiled with CFR 0.152.
 */
package com.etfl.warputils.common.data;

import com.etfl.warputils.common.abstraction.config.nbt.NbtCompound;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public record Vector3d(double x, double y, double z) {
    private static final String X_POSITION_KEY = "x_pos";
    private static final String Y_POSITION_KEY = "y_pos";
    private static final String Z_POSITION_KEY = "z_pos";

    @NotNull
    public NbtCompound toNbt() {
        NbtCompound nbt = new NbtCompound();
        nbt.putDouble(X_POSITION_KEY, this.x);
        nbt.putDouble(Y_POSITION_KEY, this.y);
        nbt.putDouble(Z_POSITION_KEY, this.z);
        return nbt;
    }

    public static Optional<Vector3d> fromNbt(NbtCompound nbt) {
        Optional<Double> x = nbt.getDouble(X_POSITION_KEY);
        Optional<Double> y = nbt.getDouble(Y_POSITION_KEY);
        Optional<Double> z = nbt.getDouble(Z_POSITION_KEY);
        if (x.isPresent() && y.isPresent() && z.isPresent()) {
            return Optional.of(new Vector3d(x.get(), y.get(), z.get()));
        }
        return Optional.empty();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object o) {
        double x1;
        double d;
        if (this == o) {
            return true;
        }
        if (!(o instanceof Vector3d)) return false;
        Vector3d vector3d = (Vector3d)o;
        try {
            x1 = d = vector3d.x();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        double y1 = d = vector3d.y();
        double z1 = d = vector3d.z();
        if (this.x != x1) return false;
        if (this.y != y1) return false;
        if (this.z != z1) return false;
        return true;
    }
}

