/*
 * Decompiled with CFR 0.152.
 */
package com.etfl.warputils.common.effects;

import com.etfl.warputils.common.data.Vector3d;
import com.etfl.warputils.common.effects.charge.IChargeEffect;
import com.etfl.warputils.common.effects.phase.PhaseEffect;
import java.util.function.Consumer;
import net.minecraft.server.level.ServerLevel;

public class EffectTask {
    private final boolean continuous;
    private int ticks = 0;
    private int progress = 0;
    private final int duration;
    private int steps = 0;
    private final int totalSteps;
    private final Consumer<Double> effect;

    public EffectTask(PhaseEffect effect, Vector3d pos, ServerLevel level) {
        this.effect = effect.effect(pos, level);
        this.duration = effect.duration();
        this.continuous = effect.continuous();
        this.totalSteps = effect.steps();
        if (this.duration <= 0) {
            this.effect.accept(1.0);
        }
    }

    public EffectTask(IChargeEffect effect, Vector3d pos, ServerLevel level, int duration) {
        this.effect = effect.effect(pos, level);
        this.duration = duration;
        this.continuous = effect.continuous();
        this.totalSteps = effect.steps(duration);
    }

    public boolean onTick() {
        if (this.ticks++ > this.duration) {
            return true;
        }
        if (this.continuous) {
            this.effect.accept((double)this.ticks / (double)this.duration);
            return false;
        }
        this.progress += this.totalSteps;
        while (this.progress >= this.duration && this.steps < this.totalSteps) {
            this.effect.accept((double)this.steps / (double)this.totalSteps);
            ++this.steps;
            this.progress -= this.duration;
        }
        return false;
    }
}

