/*
 * Decompiled with CFR 0.152.
 */
package com.etfl.warputils.common.effects.charge;

import com.etfl.warputils.common.abstraction.config.settings.EnumSettingType;
import com.etfl.warputils.common.effects.charge.EnchantingRitualEffect;
import com.etfl.warputils.common.effects.charge.EnderAccumulationEffect;
import com.etfl.warputils.common.effects.charge.FlameVortexEffect;
import com.etfl.warputils.common.effects.charge.IChargeEffect;
import com.etfl.warputils.common.effects.charge.RingsEffect;
import com.etfl.warputils.common.effects.charge.RisingRingEffect;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum ChargeEffects implements EnumSettingType<ChargeEffects>
{
    None("None", null),
    Rings("Rings", RingsEffect::new),
    RisingRing("RisingRing", RisingRingEffect::new),
    EnderAccumulation("EnderAccumulation", EnderAccumulationEffect::new),
    EnchantingRitual("EnchantingRitual", EnchantingRitualEffect::new),
    FlameVortex("FlameVortex", FlameVortexEffect::new);

    private final String optionName;
    private final Supplier<IChargeEffect> chargeAnimFactory;

    private ChargeEffects(String optionName, Supplier<IChargeEffect> chargeAnimFactory) {
        this.optionName = optionName;
        this.chargeAnimFactory = chargeAnimFactory;
    }

    public IChargeEffect get() {
        if (this.chargeAnimFactory == null) {
            return null;
        }
        return this.chargeAnimFactory.get();
    }

    @Override
    @NotNull
    public String toString() {
        return this.optionName;
    }

    @Override
    @Nullable
    public ChargeEffects fromString(@Nullable String value) {
        if (value == null) {
            return null;
        }
        for (ChargeEffects particleAnimation : ChargeEffects.values()) {
            if (!value.equals(particleAnimation.optionName)) continue;
            return particleAnimation;
        }
        return null;
    }
}

