/*
 * Decompiled with CFR 0.152.
 */
package com.etfl.warputils.common.effects.charge;

import com.etfl.warputils.common.data.Vector3d;
import com.etfl.warputils.common.effects.charge.IChargeEffect;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;

public class FlameVortexEffect
implements IChargeEffect {
    private static final double RADIUS = 2.0;

    @Override
    public boolean continuous() {
        return true;
    }

    @Override
    public int steps(int duration) {
        return 1;
    }

    @Override
    public void run(double progress, Vector3d pos, ServerLevel level) {
        progress = Math.clamp(progress, 0.0, 1.0);
        progress = 1.0 - progress;
        this.drawCircle(progress, pos, level);
    }

    private void drawCircle(double progress, Vector3d pos, ServerLevel level) {
        for (int degree = 0; degree < 360; degree += 40) {
            double radians = Math.toRadians((double)degree + 120.0 * progress);
            double x = Math.cos(radians) * 2.0 * progress;
            double z = Math.sin(radians) * 2.0 * progress;
            level.sendParticles((ParticleOptions)ParticleTypes.FLAME, pos.x() + x, pos.y() + 0.05, pos.z() + z, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }
}

