/*
 * Decompiled with CFR 0.152.
 */
package com.etfl.warputils.common.effects.charge;

import com.etfl.warputils.common.data.Vector3d;
import com.etfl.warputils.common.effects.charge.IChargeEffect;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;

public class RisingRingEffect
implements IChargeEffect {
    private static final double RADIUS = 0.75;
    private static final double HEIGHT = 2.0;

    @Override
    public boolean continuous() {
        return true;
    }

    @Override
    public int steps(int duration) {
        return 1;
    }

    @Override
    public void run(double progress, Vector3d pos, ServerLevel level) {
        progress = Math.clamp(progress, 0.0, 1.0);
        for (int degree = 0; degree < 360; degree += 10) {
            double radians = Math.toRadians(degree);
            double x = Math.cos(radians) * 0.75;
            double z = Math.sin(radians) * 0.75;
            level.sendParticles((ParticleOptions)ParticleTypes.ELECTRIC_SPARK, pos.x() + x, pos.y() + 0.1 + 1.9 * progress, pos.z() + z, 2, 0.0, 0.0, 0.0, 0.0);
        }
    }
}

