/*
 * Decompiled with CFR 0.152.
 */
package com.etfl.warputils.common.effects.phase;

import com.etfl.warputils.common.abstraction.config.settings.EnumSettingType;
import com.etfl.warputils.common.abstraction.objects.ServerPlayerWrapper;
import com.etfl.warputils.common.effects.EffectHandler;
import com.etfl.warputils.common.effects.EffectTask;
import com.etfl.warputils.common.effects.phase.AscFlameSpiralEffect;
import com.etfl.warputils.common.effects.phase.EnderEffect;
import com.etfl.warputils.common.effects.phase.FlameEffect;
import com.etfl.warputils.common.effects.phase.PhaseEffect;
import com.etfl.warputils.common.effects.phase.SmokeEffect;
import com.etfl.warputils.common.effects.phase.SonicBoomEffect;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum PhaseEffects implements EnumSettingType<PhaseEffects>
{
    None("None", null),
    Smoke("Smoke", SmokeEffect::new),
    Flame("Flame", FlameEffect::new),
    Sonic_Boom("SonicBoom", SonicBoomEffect::new),
    Ender("Ender", EnderEffect::new),
    AscFlameSpiral("FlameSpiral", AscFlameSpiralEffect::new);

    private final String optionName;
    public final Supplier<PhaseEffect> factory;

    private PhaseEffects(String optionName, Supplier<PhaseEffect> factory) {
        this.optionName = optionName;
        this.factory = factory;
    }

    public void play(ServerPlayerWrapper player) {
        if (this.factory == null || player == null) {
            return;
        }
        EffectHandler.play(new EffectTask(this.factory.get(), player.getLocation().pos(), player.getLevel()));
    }

    @Override
    @NotNull
    public String toString() {
        return this.optionName;
    }

    @Override
    @Nullable
    public PhaseEffects fromString(@Nullable String value) {
        if (value == null) {
            return null;
        }
        for (PhaseEffects teleportAnims : PhaseEffects.values()) {
            if (!value.equals(teleportAnims.optionName)) continue;
            return teleportAnims;
        }
        return null;
    }
}

