/*
 * Decompiled with CFR 0.152.
 */
package com.etfl.warputils.common.utils;

import com.etfl.warputils.common.abstraction.config.nbt.AbstractServerStateManager;
import com.etfl.warputils.common.abstraction.config.nbt.NbtCompound;
import com.etfl.warputils.common.effects.EffectsManager;
import com.etfl.warputils.common.language.MessageManager;
import com.etfl.warputils.common.utils.EventBus;
import com.etfl.warputils.common.utils.timer.cooldown.CooldownManager;
import com.etfl.warputils.features.back.data.BackManager;
import com.etfl.warputils.features.homes.data.HomesManager;
import com.etfl.warputils.features.tpas.data.TpaManager;
import com.etfl.warputils.features.warps.data.WarpManager;
import com.etfl.warputils.platform.Services;
import net.minecraft.server.MinecraftServer;

public class DataSaver {
    private static Runnable markDirty = () -> {};
    private static final String HOMES = "homes";
    private static final String WARP = "warp";
    private static final String BACK = "back";
    private static final String COOLDOWN = "cooldown";
    private static final String MESSAGE = "message";
    private static final String EFFECTS = "effects";

    private DataSaver() {
        throw new UnsupportedOperationException("Utility class");
    }

    public static void init() {
        EventBus.registerServerStartEvents(server -> {
            DataSaver.reset();
            AbstractServerStateManager state = Services.SERVER_STATE.get((MinecraftServer)server, "warputils", () -> DataSaver.toNbt(new NbtCompound()), DataSaver::fromNbt);
            markDirty = state::markDirty;
        });
    }

    public static void markDirty() {
        markDirty.run();
    }

    private static void reset() {
        HomesManager.reset();
        TpaManager.reset();
        WarpManager.reset();
        BackManager.reset();
        CooldownManager.reset();
        MessageManager.reset();
        EffectsManager.reset();
    }

    private static NbtCompound toNbt(NbtCompound nbt) {
        nbt.putCompound(HOMES, HomesManager.toNbt());
        nbt.putCompound(WARP, WarpManager.toNbt());
        nbt.putCompound(BACK, BackManager.toNbt());
        nbt.putCompound(COOLDOWN, CooldownManager.toNbt());
        nbt.putCompound(MESSAGE, MessageManager.toNbt());
        nbt.putCompound(EFFECTS, EffectsManager.toNbt());
        return nbt;
    }

    private static void fromNbt(NbtCompound nbt) {
        NbtCompound nbtCompound = new NbtCompound();
        HomesManager.fromNbt(nbt.getCompound(HOMES).orElse(nbtCompound));
        WarpManager.fromNbt(nbt.getCompound(WARP).orElse(nbtCompound));
        BackManager.fromNbt(nbt.getCompound(BACK).orElse(nbtCompound));
        CooldownManager.fromNbt(nbt.getCompound(COOLDOWN).orElse(nbtCompound));
        MessageManager.fromNbt(nbt.getCompound(MESSAGE).orElse(nbtCompound));
        EffectsManager.fromNbt(nbt.getCompound(EFFECTS).orElse(nbtCompound));
    }
}

