/*
 * Decompiled with CFR 0.152.
 */
package com.etfl.warputils.common.utils;

import com.etfl.warputils.common.abstraction.objects.ServerPlayerWrapper;
import com.etfl.warputils.common.language.MessageManager;
import com.etfl.warputils.features.back.config.BackConfig;
import com.etfl.warputils.features.homes.HomesConfig;
import com.etfl.warputils.features.tpas.TpaConfig;
import com.etfl.warputils.features.warps.WarpConfig;
import java.util.function.Supplier;

public class FeatureValidator {
    private FeatureValidator() {
        throw new UnsupportedOperationException("Utility class");
    }

    public static boolean disabled(Feature feature, ServerPlayerWrapper player) {
        if (!feature.disabled()) {
            return false;
        }
        MessageManager.sendMessage(player, feature.translationKey, false, new Object[0]);
        return true;
    }

    public static enum Feature {
        Home(HomesConfig::areHomesDisabled, "feature.homes.disabled"),
        Tpa(TpaConfig::areTpasDisabled, "feature.tpas.disabled"),
        Warp(WarpConfig::areWarpsDisabled, "feature.warps.disabled"),
        Back(BackConfig::isBackDisabled, "feature.back.disabled");

        private final Supplier<Boolean> supplier;
        private final String translationKey;

        private Feature(Supplier<Boolean> supplier, String translationKey) {
            this.supplier = supplier;
            this.translationKey = translationKey;
        }

        private boolean disabled() {
            return this.supplier.get();
        }
    }
}

