/*
 * Decompiled with CFR 0.152.
 */
package com.etfl.warputils.common.utils.timer.delay;

import com.etfl.warputils.common.abstraction.objects.ServerPlayerWrapper;
import com.etfl.warputils.common.language.MessageManager;
import com.etfl.warputils.features.back.config.BackConfig;
import com.etfl.warputils.features.homes.HomesConfig;
import com.etfl.warputils.features.tpas.TpaConfig;
import com.etfl.warputils.features.warps.WarpConfig;
import java.util.function.Supplier;

public enum DelayType {
    Home(HomesConfig::getDelay, "feature.homes.teleporting"),
    Tpa(TpaConfig::getDelay, "feature.back.teleporting"),
    Warp(WarpConfig::getDelay, "feature.warps.warping"),
    Back(BackConfig::getDelay, "feature.homes.teleporting");

    private final Supplier<Integer> delay;
    private final String delayMessageTranslationKey;

    private DelayType(Supplier<Integer> delay, String delayMessageTranslationKey) {
        this.delay = delay;
        this.delayMessageTranslationKey = delayMessageTranslationKey;
    }

    public int get() {
        return this.delay.get();
    }

    public void message(ServerPlayerWrapper player, int remainingTicks) {
        MessageManager.sendMessage(player, this.delayMessageTranslationKey, false, "" + (int)Math.ceil((double)remainingTicks / 20.0));
    }
}

