/*
 * Decompiled with CFR 0.152.
 */
package com.etfl.warputils.common.utils.timer.fightCooldown;

import com.etfl.warputils.common.abstraction.objects.ServerPlayerWrapper;
import com.etfl.warputils.common.language.MessageManager;
import com.etfl.warputils.common.utils.timer.fightCooldown.FightCooldownConfig;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;

public class FightCooldownManager {
    private static final Map<UUID, Long> timestamps = new HashMap<UUID, Long>();

    private FightCooldownManager() {
        throw new UnsupportedOperationException("Utility class");
    }

    public static boolean onCooldown(@NotNull ServerPlayerWrapper player) {
        int cooldown = FightCooldownConfig.getCooldown();
        if (cooldown <= 0) {
            return false;
        }
        long time = player.getTime() - timestamps.getOrDefault(player.getUUID(), 0L);
        if (time >= (long)cooldown) {
            return false;
        }
        MessageManager.sendMessage(player, "common.fight_cooldown.active", false, (int)Math.ceil((double)((long)cooldown - time) / 20.0));
        return true;
    }

    public static void startCooldown(@NotNull ServerPlayerWrapper player) {
        timestamps.put(player.getUUID(), player.getTime());
    }
}

