/*
 * Decompiled with CFR 0.152.
 */
package com.etfl.warputils.features.back;

import com.etfl.warputils.common.abstraction.commands.LiteralCommandBuilder;
import com.etfl.warputils.common.abstraction.commands.wrappers.CommandContextWrapper;
import com.etfl.warputils.common.abstraction.commands.wrappers.CommandSourceWrapper;
import com.etfl.warputils.common.abstraction.objects.ServerPlayerWrapper;
import com.etfl.warputils.common.data.Location;
import com.etfl.warputils.common.language.MessageManager;
import com.etfl.warputils.common.utils.DataSaver;
import com.etfl.warputils.common.utils.EventBus;
import com.etfl.warputils.common.utils.FeatureValidator;
import com.etfl.warputils.common.utils.timer.cooldown.CooldownManager;
import com.etfl.warputils.common.utils.timer.cooldown.CooldownType;
import com.etfl.warputils.common.utils.timer.delay.DelayManager;
import com.etfl.warputils.common.utils.timer.delay.DelayType;
import com.etfl.warputils.common.utils.timer.fightCooldown.FightCooldownManager;
import com.etfl.warputils.features.back.config.BackConfig;
import com.etfl.warputils.features.back.data.BackManager;
import org.jetbrains.annotations.NotNull;

public class BackCommand {
    private BackCommand() {
        throw new UnsupportedOperationException("Utility class");
    }

    public static void register() {
        EventBus.addCommand((LiteralCommandBuilder)((LiteralCommandBuilder)LiteralCommandBuilder.literal("back").requires(CommandSourceWrapper::isPlayer)).executes(BackCommand::run));
    }

    private static int run(CommandContextWrapper context) {
        ServerPlayerWrapper player = context.getSource().getPlayer();
        if (FeatureValidator.disabled(FeatureValidator.Feature.Back, player)) {
            return 0;
        }
        if (!BackManager.backPresent(player.getUUID(), player.getTime())) {
            return BackCommand.noBack(player);
        }
        if (CooldownManager.onCooldown(CooldownType.Back, player)) {
            return 0;
        }
        if (FightCooldownManager.onCooldown(player)) {
            return 0;
        }
        DelayManager.startDelay(DelayType.Back, player, BackCommand::teleport);
        return 1;
    }

    private static int noBack(ServerPlayerWrapper player) {
        MessageManager.sendMessage(player, "feature.back.none", false, new Object[0]);
        return 0;
    }

    private static void teleport(@NotNull ServerPlayerWrapper player) {
        Location back = BackManager.getLocation(player.getUUID());
        if (back == null) {
            return;
        }
        switch (BackConfig.getMode()) {
            case BackBack: {
                BackManager.add(player);
                break;
            }
            case SingleUse: {
                BackManager.remove(player.getUUID());
            }
        }
        player.teleport(back);
        CooldownManager.startCooldown(CooldownType.Back, player);
        MessageManager.sendMessage(player, "feature.back.teleported", false, new Object[0]);
        DataSaver.markDirty();
    }
}

